#ifndef WMGENERAL_H_INCLUDED
#define WMGENERAL_H_INCLUDED
/* Defines */
#define MAX_MOUSE_REGION (8)

/* Typedefs */
typedef struct _rckeys rckeys;

struct _rckeys {
	const char	*label;
	char		**var;
};

typedef struct {
	Pixmap		pixmap;
	Pixmap		mask;
	XpmAttributes	attributes;
} XpmIcon;


/* Function Prototypes */
void AddMouseRegion(int index, int left, int top, int right, int bottom);
int CheckMouseRegion(int x, int y);
void openXwindow(int argc, char *argv[], char **, char *, int, int);
void RedrawWindow(void);
void RedrawWindowXY(int x, int y);
void copyXPMArea(int, int, int, int, int, int);
void copyXBMArea(int, int, int, int, int, int);
void setMaskXY(int, int);
void parse_rcfile(const char *, rckeys *);
void eraseRect(int x, int y, int x2, int y2, char *bgcolorname);
void drawString(int dest_x, int dest_y, const char *string,
                                char *colorname, char *bgcolorname,
		int right_justify);
void drawnString(int dest_x, int dest_y, const char *string,
                                char *colorname, char *bgcolorname,
		int right_justify, int len);
void GetXPM(XpmIcon *wmgen, char *pixmap_bytes[]);
void drawImageString(int dest_x, int dest_y, const char *string);

#endif
