/*	wmgeneral was taken from wmppp.

	It has a lot of routines which most of the wm* programs use.

	------------------------------------------------------------
	Author: Martijn Pieterse (pieterse@xs4all.nl)

	--- CHANGES: ---
	02/05/1998 (Martijn Pieterse, pieterse@xs4all.nl)
		* changed the read_rc_file to parse_rcfile, as suggester by Marcelo E. Magallon
		* debugged the parse_rc file.
	30/04/1998 (Martijn Pieterse, pieterse@xs4all.nl)
		* Ripped similar code from all the wm* programs,
		  and put them in a single file.
*/

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <ctype.h>
#include <stdarg.h>
#include <X11/Xlib.h>
#include <X11/xpm.h>
#include <X11/extensions/shape.h>
#include "wmuim.h"
#include "wmgeneral.h"

/* X11 Variables */
int		screen;
int		x_fd;
int		d_depth;
XSizeHints	mysizehints;
XWMHints	mywmhints;
Pixel		back_pix, fore_pix;
char		*Geometry = "";
Window		iconwin, win;
Pixmap		pixmask;

/* Mouse Regions */
typedef struct {
	int	enable;
	int	top;
	int	bottom;
	int	left;
	int	right;
} MOUSE_REGION;

#define MAX_MOUSE_REGION (8)
MOUSE_REGION	mouse_region[MAX_MOUSE_REGION];

/* Global variable */
extern Display	*display;
extern Window   Root;
extern GC       NormalGC;
extern XpmIcon  wmgen;
extern XpmIcon  text_pixmap;
extern XFontSet fontset;

/* Function Prototypes */
void dprintf(const char *fmt, ...);
/* static void GetXPM(XpmIcon *, char **);*/
static Pixel GetColor(char *);
void RedrawWindow(void);
void AddMouseRegion(int, int, int, int, int);
int CheckMouseRegion(int, int);
void createXBMfromXPM(char *xbm_org, char **xpm, int sx, int sy);

/*****************************************************************************\
|* createXBMfromXPM                                                          *|
\*****************************************************************************/
void createXBMfromXPM(char *xbm_org, char **xpm, int sx, int sy)
{

	int i, j, k;
	int width, height, numcol, depth;
	int zero = 0;
	unsigned char bwrite;
	int bcount;
	int curpixel;
	char *xbm;
	xbm = xbm_org;

	sscanf(*xpm, "%d %d %d %d", &width, &height, &numcol, &depth);

	for (k = 0; k != depth; k++) {
		zero <<= 8;
		zero |= xpm[1][k];
	}

	for (i = numcol + 1; i < numcol + sy + 1; i++) {
		bcount = 0;
		bwrite = 0;
		for (j = 0; j < sx * depth; j += depth) {
			bwrite >>= 1;

			curpixel = 0;
			for (k = 0; k != depth; k++) {
				curpixel <<= 8;
				curpixel |= xpm[i][j + k];
			}

			if (curpixel != zero) {
				bwrite += 128;
			}
			bcount++;
			if (bcount == 8) {
				*xbm = bwrite;
				xbm++;
				bcount = 0;
				bwrite = 0;
			}
		}
	}

}

void eraseRect(int x, int y, int x2, int y2, char *bgcolorname)
{
        XSetForeground(display, NormalGC, GetColor(bgcolorname));
        XFillRectangle(display, wmgen.pixmap, NormalGC, x, y, x2 - x,
                                   y2 - y);
}

void drawnString(int dest_x, int dest_y, const char *string,
                                char *colorname, char *bgcolorname,
                                int right_justify, int len)
{
        XSetForeground(display, NormalGC, GetColor(colorname));
        XSetBackground(display, NormalGC, GetColor(bgcolorname));
/*
        if (right_justify)
                dest_x -= XTextWidth(f, string, len);
*/
	if (strlen(string) < len) {
		len = strlen(string);
	}
        XmbDrawString(display, wmgen.pixmap, fontset, NormalGC, dest_x, dest_y,
		      string, len);

}

void drawString(int dest_x, int dest_y, const char *string,
                                char *colorname, char *bgcolorname,
                                int right_justify)
{
        int len = strlen(string);
//        assert(colorname != NULL);
        XSetForeground(display, NormalGC, GetColor(colorname));
        XSetBackground(display, NormalGC, GetColor(bgcolorname));
/*
        if (right_justify)
                dest_x -= XTextWidth(f, string, len);
*/
        XmbDrawString(display, wmgen.pixmap, fontset, NormalGC, dest_x, dest_y,
		      string, len);
}


void drawImageString(int dest_x, int dest_y, const char *string)
{
        int len = strlen(string);
	int src_x = 0;
	int src_y = 0;
	int i;
	for (i = 0; i < 6; i++) {
	  if (i >= len) {
	    XCopyArea(display, text_pixmap.pixmap, wmgen.pixmap, NormalGC,
		      1, 27, 5, 9, dest_x, dest_y);
	  } else {
	    if (isdigit(string[i])) {
	      src_x = 1+(string[i]-'0')*6;
	      src_y = 0;
	    } else if (isalpha(string[i])) {
	      src_x = 1+(string[i]-'a')*6;
	      src_y = 9;
	    } else {
	      src_x = 1;
	      src_y = 27;
	    }
		       
	    XCopyArea(display, text_pixmap.pixmap, wmgen.pixmap, NormalGC,
		      src_x,  src_y, 5, 9, dest_x, dest_y);
	  }
	  dest_x += 6;
	}
}

/* read_rc_file */
void parse_rcfile(const char *filename, rckeys *keys)
{
	char	*p;
	char	temp[128];
	char	*tokens = " :	\n";
	FILE	*fp;
	int	i,key;

	fp = fopen(filename, "r");
	if (fp) {
		while (fgets(temp, 128, fp)) {
			key = 0;
				while (key >= 0 && keys[key].label) {
					if ((p = strstr(temp, keys[key].label))) {
						p += strlen(keys[key].label);
						p += strspn(p, tokens);
						if ((i = strcspn(p, "#\n"))) p[i] = 0;
						free(*keys[key].var);
						*keys[key].var = strdup(p);
						key = -1;
					} else key++;
				}
			}
		fclose(fp);
	}
}

void GetXPM(XpmIcon *wmgen, char *pixmap_bytes[])
{
	XWindowAttributes	attributes;
	int			err;

	/* For the colormap */
	XGetWindowAttributes(display, Root, &attributes);

	wmgen->attributes.valuemask |= (XpmReturnPixels | XpmReturnExtensions);

	err = XpmCreatePixmapFromData(display, Root, pixmap_bytes, &(wmgen->pixmap),
		&(wmgen->mask), &(wmgen->attributes));

	if (err != XpmSuccess) {
		fprintf(stderr, "Not enough free colorcells.\n");
		exit(1);
	}
}

static Pixel GetColor(char *name)
{
	XColor		color;
	XWindowAttributes	attributes;

	XGetWindowAttributes(display, Root, &attributes);

	color.pixel = 0;
	if (!XParseColor(display, attributes.colormap, name, &color)) {
		fprintf(stderr, "wm.app: can't parse %s.\n", name);
	} else if (!XAllocColor(display, attributes.colormap, &color)) {
		fprintf(stderr, "wm.app: can't allocate %s.\n", name);
	}
	return color.pixel;
}

static int flush_expose(Window w)
{
	XEvent	dummy;
	int		i=0;

	while (XCheckTypedWindowEvent(display, w, Expose, &dummy))
		i++;
	return i;
}

void RedrawWindow(void)
{
	flush_expose(iconwin);
	XCopyArea(display, wmgen.pixmap, iconwin, NormalGC,
		0,0, wmgen.attributes.width, wmgen.attributes.height, 0,0);

	flush_expose(win);
	XCopyArea(display, wmgen.pixmap, win, NormalGC,
		0,0, wmgen.attributes.width, wmgen.attributes.height, 0,0);
}

void RedrawWindowXY(int x, int y)
{
	flush_expose(iconwin);
	XCopyArea(display, wmgen.pixmap, iconwin, NormalGC,
		x,y, wmgen.attributes.width, wmgen.attributes.height, 0,0);
	flush_expose(win);
	XCopyArea(display, wmgen.pixmap, win, NormalGC,
		x,y, wmgen.attributes.width, wmgen.attributes.height, 0,0);
}

void AddMouseRegion(int index, int left, int top, int right, int bottom)
{
     dprintf("index = %d, left = %d, top = %d, right = %d, bottom = %d\n",
	     index, left, top, right, bottom);
     if (index < MAX_MOUSE_REGION) {
	  mouse_region[index].enable = 1;
	  mouse_region[index].top = top;
	  mouse_region[index].left = left;
	  mouse_region[index].bottom = bottom;
	  mouse_region[index].right = right;
     }
}

int CheckMouseRegion(int x, int y)
{
     int i;

     for (i=0; i < MAX_MOUSE_REGION; i++) {
	  if (mouse_region[i].enable &&
	      x <= mouse_region[i].right &&
	      x >= mouse_region[i].left &&
	      y <= mouse_region[i].bottom &&
	      y >= mouse_region[i].top)
/*			return (i-1);*/
	       return i;
     }
     return -1;
}

void copyXPMArea(int x, int y, int sx, int sy, int dx, int dy)
{
	XCopyArea(display, wmgen.pixmap, wmgen.pixmap, NormalGC,
		  x, y, sx, sy, dx, dy);
}

void copyXBMArea(int x, int y, int sx, int sy, int dx, int dy)
{
	XCopyArea(display, wmgen.mask, wmgen.pixmap, NormalGC,
		  x, y, sx, sy, dx, dy);
}

void setMaskXY(int x, int y)
{
	XShapeCombineMask(display, win, ShapeBounding,
			  x, y, pixmask, ShapeSet);
	XShapeCombineMask(display, iconwin, ShapeBounding,
			  x, y, pixmask, ShapeSet);
}

void openXwindow(int argc, char *argv[], char *pixmap_bytes[],
		 char *pixmask_bits, int pixmask_width, int pixmask_height)
{
	unsigned int	borderwidth = 1;
	XClassHint	classHint;
	char		*display_name = NULL;
	char		*wname = argv[0];
	XTextProperty	name;
	XGCValues	gcv;
	unsigned long	gcm;
	int		i, dummy = 0;
	char tmp_mask_bits[WMUIM_WINDOW_WIDTH * WMUIM_WINDOW_HEIGHT];

	for (i=1; argv[i]; i++) {
		if (!strcmp(argv[i], "-display"))
			display_name = argv[i+1];
	}

	if (!(display = XOpenDisplay(display_name))) {
		fprintf(stderr, "%s: can't open display %s\n",
			wname, XDisplayName(display_name));
		exit(1);
	}
	screen  = DefaultScreen(display);
	Root    = RootWindow(display, screen);
	d_depth = DefaultDepth(display, screen);
	x_fd    = XConnectionNumber(display);

	/* Convert XPM to XImage */
	GetXPM(&wmgen, pixmap_bytes);

	/* Create a window to hold the stuff */
	mysizehints.flags = USSize | USPosition;
	mysizehints.x = 0;
	mysizehints.y = 0;

	back_pix = GetColor("white");
	fore_pix = GetColor("black");

	XWMGeometry(display, screen, Geometry, NULL, borderwidth, 
		    &mysizehints, &mysizehints.x, &mysizehints.y,
		    &mysizehints.width, &mysizehints.height, &dummy);

	mysizehints.width = 64;
	mysizehints.height = 64;

	win = XCreateSimpleWindow(display, Root, mysizehints.x, mysizehints.y,
				  mysizehints.width, mysizehints.height,
				  borderwidth, fore_pix, back_pix);

	iconwin = XCreateSimpleWindow(display, win,
				      mysizehints.x, mysizehints.y,
				      mysizehints.width, mysizehints.height,
				      borderwidth, fore_pix, back_pix);

	/* Activate hints */
	XSetWMNormalHints(display, win, &mysizehints);
	classHint.res_name = wname;
	classHint.res_class = wname;
	XSetClassHint(display, win, &classHint);

	XSelectInput(display, win,
		     ButtonPressMask | ExposureMask | ButtonReleaseMask |
		     PointerMotionMask | StructureNotifyMask);
	XSelectInput(display, iconwin,
		     ButtonPressMask | ExposureMask | ButtonReleaseMask |
		     PointerMotionMask | StructureNotifyMask |
		     EnterWindowMask | LeaveWindowMask);

	if (XStringListToTextProperty(&wname, 1, &name) == 0) {
		fprintf(stderr, "%s: can't allocate window name\n", wname);
		exit(1);
	}

	XSetWMName(display, win, &name);

	/* Create GC for drawing */
	gcm = GCForeground | GCBackground | GCGraphicsExposures;
	gcv.foreground = fore_pix;
	gcv.background = back_pix;
	gcv.graphics_exposures = 0;
	NormalGC = XCreateGC(display, Root, gcm, &gcv);

	/* ONLYSHAPE ON */
	if (pixmask_bits == NULL) {
	     dprintf("auto mask !\n");
	     createXBMfromXPM(tmp_mask_bits, pixmap_bytes, pixmask_width,
			      pixmask_height);
	     pixmask = XCreateBitmapFromData(display, win, tmp_mask_bits, 
					     pixmask_width, pixmask_height);

	} else {
	     pixmask = XCreateBitmapFromData(display, win, pixmask_bits, 
					     pixmask_width, pixmask_height);
	}
	XShapeCombineMask(display, win, ShapeBounding,
			  0, 0, pixmask, ShapeSet);
	XShapeCombineMask(display, iconwin, ShapeBounding,
			  0, 0, pixmask, ShapeSet);

	/* ONLYSHAPE OFF */
	mywmhints.initial_state = WithdrawnState;
	mywmhints.icon_window = iconwin;
	mywmhints.icon_x = mysizehints.x;
	mywmhints.icon_y = mysizehints.y;
	mywmhints.window_group = win;
	mywmhints.flags = StateHint | IconWindowHint | IconPositionHint | WindowGroupHint;

	XSetWMHints(display, win, &mywmhints);

	XSetCommand(display, win, argv, argc);
	XMapWindow(display, win);
}
