#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include <stdio.h>
#include <stdlib.h>
#include <X11/X.h>
#include <X11/xpm.h>
#include <X11/Xlib.h>
#include <X11/Xlocale.h>
#include <unistd.h>
#include <string.h>

#include <uim.h>
#include <uim-helper.h>
#include <uim-im-switcher.h>

#include <iconv.h>

#ifdef MEMCHECK
#include <memcheck.h>
#endif /* MEMCHECK */

#include "wmgeneral.h"
#include "uim-helper-wm.h"
#ifdef USE_IMLIB2
#include "wm-imlib.h"
#endif

#define MAX_LIST_LINE 64

#define BUFSIZE 1024

#define SW_BUTTON_INDEX 0
#define LABEL_BUTTON_INDEX 1
#define INPUT_BUTTON_INDEX 2
#define CONFIG_BUTTON_INDEX 3
#define DICT_BUTTON_INDEX 4

typedef struct _wmuim_list {
     struct _wmuim_list *next;
     char *indication_id;
     char *iconic_label;
     char *label_string;
     char *short_desc;
     char *action_id;
     int selected;
} wmuim_list;

wmuim_list *mode_list, *input_list;

extern Bool graphical_mode;

void dprintf(const char *fmt, ...);

static char *convert(char *tocode, char *fromcode, char *string);
static char **strsplit(char *str, char *delimiter, int max);
static void wmuim_draw_prop_list(wmuim_list *list);
static void prop_menu_activate(wmuim_list *list, int index);

static void wmuim_select(wmuim_list *list, char *label);
static wmuim_list* wmuim_new(wmuim_list *list, char *indication_id,
			     char *iconic_label,
			     char *label_string,
			     char *short_desc,
			     char *action_id);
static wmuim_list* wmuim_delete(wmuim_list *list, wmuim_list *target);
static wmuim_list* wmuim_delete_all(wmuim_list *list);
static void wmuim_activate_next_item(wmuim_list *list);
static void wmuim_erase_current_input(void);
static void wmuim_draw_current_input(wmuim_list *list);
static void wmuim_draw_current_label(wmuim_list *list);
static void wmuim_draw_prop_list(wmuim_list *list);
static void wmuim_draw_im_name(char *im_name);

#ifdef DEBUG
static void wmuim_dump_list(wmuim_list *list);
#endif

static int uim_fd;
#define UIM_IM_SWITCHER "uim-im-switcher-gtk"
#define UIM_PREF "uim-pref-gtk"
char *uim_pref_cmd, *uim_im_switcher_cmd;

void wmuim_set_icon_buttons()
{
     char icon_file_name[MAX_PATH_LENGTH];
     
     sprintf(icon_file_name, "%s/uim-icon.png", UIM_ICON_PATH);
     drawImage(G_CONFIG_AREA_LEFT + 1, G_CONFIG_AREA_TOP,
	       G_SMALL_ICON_SIZE, G_SMALL_ICON_SIZE, icon_file_name);
     
     sprintf(icon_file_name, "%s/uim-dict.png", UIM_ICON_PATH);
     drawImage(G_DICT_AREA_LEFT + 1, G_DICT_AREA_TOP,
	       G_SMALL_ICON_SIZE, G_SMALL_ICON_SIZE, icon_file_name);
     
}


static char **strsplit(char *str, char *delimiter, int max)
{
     char **str_array;
     char *reminder;
     char *s;
     int n = 0;

     str_array = malloc(sizeof(char*)*MAX_LIST_LINE);
     reminder = str;
     s = strstr(reminder, delimiter);
     while(s) {
	  int len;
	  char *new_string;

	  len = s - reminder;
	  new_string = malloc(sizeof(char)*(len + 1));
    
	  strncpy(new_string, reminder, len);
	  new_string[len] = '\0';
/*	  dprintf("new_string = %p:%s\n", new_string, new_string);*/
	  str_array[n] = new_string;
	  // listに登録
	  n++;
	  reminder = s + 1;
	  s = strstr(reminder, delimiter);
     }
     if (s)
	  free(s);

     str_array[n] = reminder;
     str_array[n+1] = "";

/*     dprintf ("reminder = %p:%s\n", reminder, reminder); */
		
     return str_array;

}

int wmuim_set_uim_pref_cmd(char *str)
{
     free(uim_pref_cmd);
     uim_pref_cmd = strdup(str);
     if (uim_pref_cmd == NULL) {
	  return -1;
     }
     return 0;
}

int wmuim_set_uim_im_switcher_cmd(char *str)
{
     free(uim_im_switcher_cmd);
     uim_im_switcher_cmd = strdup(str);

     dprintf ("uim_im_switcher_cmd = %s\n", uim_im_switcher_cmd);

     if (uim_im_switcher_cmd == NULL) {
	  return -1;
     }
     return 0;
}

static void wmuim_im_change(char *imname)
{
     wmuim_draw_im_name(imname);
}

static wmuim_list* wmuim_delete_all(wmuim_list *list)
{
     wmuim_list *p;
     p = list;
     while (p != NULL)
	  p = wmuim_delete(p, p);
     return p;
}

static void helper_applet_prop_list_update(char **lines)
{
     int i, n;
     char **pair = NULL;
     char *charset = NULL;

     char *indication_id = NULL;
     char *iconic_label = NULL;
     char *label_string = NULL;
     char *short_desc = NULL;
     char *action_id = NULL;
     int branch = -1;
     wmuim_list *tmp_list = NULL;

     /* first line is "prop_list_update" */
     /* 2nd line is "charset=..." */
     if (lines && lines[1]) {
	  pair = strsplit(lines[1], "=", 0);
     } else {
	  return;
     }

     if(pair && pair[0] && pair[1] && strcmp("charset", pair[0]) == 0) {
	  charset = strdup(pair[1]);
	  free(pair);
     } else {
	  free(pair);
	  return;
     }
	
     /* 3rd line is branch ... */
	
     n = 0;
     for(i = 2; lines[i] != NULL; i++) {
	  if (strcmp("", lines[i]) == 0) {
	       if (branch == 0) {
		    tmp_list = NULL;
	       }
	       if (branch == 1) {
		    mode_list = wmuim_delete_all(mode_list);
		    mode_list = tmp_list;
		    tmp_list = NULL;
	       } else if (branch == 2) {
		    input_list = wmuim_delete_all(input_list);
		    input_list = tmp_list;
	       }
	       break;
	  }
	  pair = strsplit(lines[i], "\t", 0);
	  if (strcmp("branch", pair[0]) == 0) {
	       if (branch == 0) {
		    mode_list = wmuim_delete_all(mode_list);
		    mode_list = tmp_list;
		    tmp_list = NULL;
	       }
	       if (branch == 1) {
		    mode_list = wmuim_delete_all(mode_list);
		    mode_list = tmp_list;
		    tmp_list = NULL;
	       }
	       branch++;
	  } else if (strcmp("leaf", pair[0]) == 0) {
	       /*
		 indication_id = convert("euc-jp", charset, pair[1]);
		 iconic_label = convert("euc-jp", charset, pair[2]);
		 label_string = convert("euc-jp", charset, pair[3]);
		 short_desc = convert("euc-jp", charset, pair[4]);
		 action_id = convert("euc-jp", charset, pair[5]);
	       */
	       indication_id = strdup(pair[1]);
	       iconic_label = strdup(pair[2]);
	       label_string = strdup(pair[3]);
	       short_desc = strdup(pair[4]);
	       action_id = strdup(pair[5]);
	       tmp_list = wmuim_new(tmp_list, indication_id,
				    iconic_label,
				    label_string,
				    short_desc,
				    action_id);
	       if (pair[6] && strcmp(pair[6], "*") ==0) {
		    wmuim_select(tmp_list, iconic_label);
	       }

	       n++;
	  }
     }
     wmuim_draw_prop_list(mode_list);
     wmuim_draw_current_label(mode_list);
     if (branch == 2)
	  wmuim_draw_current_input(input_list);
     else
	  wmuim_erase_current_input();

     if (charset) 
	  free(charset);
     return;
}


static void helper_applet_im_list(char **lines)
{
     char **pair = NULL;
     char *charset = NULL;
     int i = 0;

     if(lines && lines[1] ) {
	  pair = strsplit(lines[1], "=", 0);
     } else {
	  return;
     }

     if(pair && pair[0] && pair[1] && strcmp("charset", pair[0]) == 0) {
	  charset = strdup(pair[1]);
	  free(pair);
     } else {
	  free(pair);
	  return;
     }

     i = 2; /* resetting temporary variable */
     while(lines[i] && strcmp("", lines[i]) != 0) {
	  pair = strsplit(lines[i], "\t", 0);
	  if(pair && pair[0] && pair[1]) {
	       if (strcmp("selected", pair[3]) == 0) {
		    dprintf("im = %s\n", pair[0]);
		    wmuim_draw_im_name(pair[0]);
	       }
	  }
	  if (pair)
	       free(pair);
	  i++;
     }

     if(charset)
	  free(charset);


}

static void helper_applet_parse_helper_str(char *str)
{
     char **lines;
     lines = strsplit(str, "\n", 0);
     if(lines && lines[0]) {
	  dprintf("%s\n", lines[0]);
	  if (strcmp("prop_list_update", lines[0]) == 0) {
	       helper_applet_prop_list_update(lines);
	  } else if (strcmp("im_list", lines[0]) == 0) {
	       helper_applet_im_list(lines);
	       dprintf("im_list: %s\n", str);
	  } else if (strcmp("focus_in", lines[0]) == 0) {
	       dprintf("focus_in\n");
	  } else if (strcmp("focus_out", lines[0]) == 0) {
	       dprintf("focus_out\n");
	  } else if (strcmp("im_list_get", lines[0]) == 0) {
	       dprintf("im_list_get\n");
	  } else if (strcmp("prop_list_get", lines[0]) == 0) {
	       dprintf("prop_list_get\n");
	  } else if (strcmp("prop_activate", lines[0]) == 0) {
	       dprintf("prop_activate: %s\n", str);
	  } else if (strcmp("im_change_whole_desktop", lines[0]) == 0) {
	       dprintf("im_change_whole_desktop: %s\n", str);
	       wmuim_im_change(lines[1]);
	  } else if (strcmp("im_change_this_application_only", lines[0]) == 0) {
	       dprintf("im_change_this_application_only: %s\n", str);
	       wmuim_im_change(lines[1]);
	  } else if (strcmp("im_change_this_text_area_only", lines[0]) == 0) {
	       dprintf("%s: %s\n", lines[0], str);
	       wmuim_im_change(lines[1]);
	  } else {
	       dprintf("%s\n", lines[0]);
	  }
     }
     free(lines);
}

static void helper_disconnect_cb(void)
{
     uim_fd = -1;
     dprintf("helper_disconnect_cb\n");
}

static void commit_cb(void *ptr, const char *commit_str)
{
     dprintf("%s commited\n", commit_str);
}

static void check_helper_connection()
{
     if(uim_fd < 0) {
	  uim_fd = uim_helper_init_client_fd(helper_disconnect_cb);
	  dprintf("uim_fd = %d\n", uim_fd);
     }
}

static void uim_fd_read_cb(int fd)
{
     char *tmp;

     uim_helper_read_proc(fd);
     while ((tmp = uim_helper_get_message())) {
	  dprintf("uim_fd_read_cb\n");
	  helper_applet_parse_helper_str(tmp);
	  free(tmp); tmp = NULL;
     }
		    
}

static char* convert(char *tocode, char *fromcode, char *string)
{
     iconv_t cd;
     size_t outbufsize = BUFSIZE;
     size_t inleft, outleft;
     size_t ret;
     char *outbuf;
     char *in_p = string;

     dprintf("string = %s\n", string);
     dprintf("fromcode = %s\n", fromcode);
     outbuf = malloc(BUFSIZE);

     {
	  char *out_p = outbuf;
	  inleft = string + strlen(string) - in_p;

	  outleft = outbufsize;


	  cd = iconv_open(tocode, fromcode);
	  ret = iconv(cd, &in_p, &inleft, &out_p, &outleft);
	  *out_p = '\0';
	  iconv_close(cd);
	  dprintf("ret = %d\n", ret);
	  dprintf("out_p = %s:outbyteleft = %d\n", out_p, outleft);
     }
     dprintf("outbuf = %s\n", outbuf);
     return outbuf;
}

static void wmuim_select(wmuim_list *list, char *label)
{
     wmuim_list *p;
     p = list;
     while (p != NULL) {
	  if (strcmp(p->iconic_label, label) == 0) {
	       p->selected = 1;
	  } else {
	       p->selected = 0;
	  }
	  p = p->next;
     }
     return;
}


/*
  static wmuim_list* wmuim_new(wmuim_list *list, char *label, char *prop,
  char *description, char *function) 
*/
static wmuim_list* wmuim_new(wmuim_list *list, char *indication_id,
			     char *iconic_label,
			     char *label_string,
			     char *short_desc,
			     char *action_id)
{
     wmuim_list *p, *tmp;
     p = malloc(sizeof(wmuim_list));
     memset(p, 0, sizeof(wmuim_list));
     p->indication_id = indication_id;
     p->iconic_label = iconic_label;
     p->label_string = label_string;
     p->short_desc = short_desc;
     p->action_id = action_id;
     p->next = NULL;
     if (list == NULL) {
	  list = p;
	  return list;
     }
     tmp = list;
     while (tmp->next != NULL)
	  tmp = tmp->next;
     tmp->next = p;
     return list;
}

static wmuim_list* wmuim_delete(wmuim_list *list, wmuim_list *target)
{
     wmuim_list *p;
     p = list;
     if (p == target) {
	  p = target->next;
     } else {
	  while (p->next != target || p != NULL)
	       p = p->next;
	  p->next = target->next;
     }
     free(target->indication_id);
     free(target->iconic_label);
     free(target->label_string);
     free(target->short_desc);
     free(target->action_id);
     free(target);
     return p;
}

#ifdef DEBUG
static void wmuim_dump_list(wmuim_list *list)
{
     wmuim_list *p;
     int i = 0;
     p = list;
     if (p == NULL)
	  dprintf("NULL\n");
     while (p != NULL) {
	  dprintf("%d:", i);
	  dprintf("label = %s:", p->label);
	  dprintf("prop = %s:", p->prop);
	  dprintf("desc = %s:", p->description);
	  dprintf("func = %s:", p->function);
	  dprintf("is sel = %d:", p->selected);
	  dprintf("next = %p\n", p->next);
	  p = p->next;
	  i++;
     }
}
#endif /* DEBUG */

static void wmuim_activate_next_item(wmuim_list *list)
{
     wmuim_list *p;
     int i = 0;

     if (list == NULL)
	  return;
     p = list;
     while (p != NULL) {
	  i++;
	  if (p->selected == 1) {
	       p->selected = 0;
	       if (p->next != NULL) {
		    p->next->selected = 1;
	       } else {
		    list->selected = 1;
		    i = 0;
	       }
	       break;
	  }
	  p = p->next;
     }
     if (p != NULL) {
	  prop_menu_activate(list, i);
     }
     return;
}

static void prop_menu_activate(wmuim_list *list, int index)
{
     char buf[256];
     wmuim_list *p;
     int i = 0;

     if (list == NULL) {
	  return;
     }
     p = list;
     while (p != NULL && index != i) {
	  i++;
	  p = p->next;
     }
     snprintf(buf, 256, "prop_activate\n%s\n", p->action_id);
     dprintf("send_message:%s\n", buf);
     uim_helper_send_message(uim_fd, buf);
     wmuim_select(list, p->iconic_label);
     return;
}

static void wmuim_erase_current_input()
{
     if (graphical_mode == True) {
	  eraseRect(G_INPUT_AREA_LEFT, 
		    G_INPUT_AREA_TOP,
		    G_INPUT_AREA_RIGHT,
		    G_INPUT_AREA_BOTTOM,
		    G_BACKGROUND_COLOR);
     } else {
	  eraseRect(INPUT_AREA_LEFT, 
		    INPUT_AREA_TOP,
		    INPUT_AREA_RIGHT,
		    INPUT_AREA_BOTTOM,
		    BACKGROUND_COLOR);
     }
     return;
}

static void wmuim_draw_current_input(wmuim_list *list)
{
     wmuim_list *p;
     char icon_file_name[MAX_PATH_LENGTH];
     if (graphical_mode == True) {
	  eraseRect(G_INPUT_AREA_LEFT, 
		    G_INPUT_AREA_TOP,
		    G_INPUT_AREA_RIGHT,
		    G_INPUT_AREA_BOTTOM,
		    G_BACKGROUND_COLOR);
     
     } else {
	  eraseRect(INPUT_AREA_LEFT, 
		    INPUT_AREA_TOP,
		    INPUT_AREA_RIGHT,
		    INPUT_AREA_BOTTOM,
		    BACKGROUND_COLOR);
     }
     if (list == NULL) {
	  return;
     }
     p = list;
     while (p != NULL) {
	  if (p->selected == 1) {
	       if (graphical_mode == True) {
		    sprintf(icon_file_name, "%s/%s.png",
			    UIM_ICON_PATH, p->indication_id);
		    drawImage(G_INPUT_AREA_LEFT + 1, G_INPUT_AREA_TOP + 1,
			      G_LARGE_ICON_SIZE, G_LARGE_ICON_SIZE,
			      icon_file_name);
				    
	       } else {
		    drawString(INPUT_AREA_LEFT, INPUT_AREA_BOTTOM-2,
			       p->iconic_label,
			       SELECTED_TEXT_COLOR, BACKGROUND_COLOR, 0);
	       }
	       break;
	  }
	  p = p->next;
     }
     RedrawWindow();
     return;
}

static void wmuim_draw_current_label(wmuim_list *list)
{
     wmuim_list *p;
     char icon_file_name[MAX_PATH_LENGTH];
     if (graphical_mode == True) {
	  eraseRect(G_LABEL_AREA_LEFT, 
		    G_LABEL_AREA_TOP,
		    G_LABEL_AREA_RIGHT,
		    G_LABEL_AREA_BOTTOM,
		    G_BACKGROUND_COLOR);
     } else {
	  eraseRect(LABEL_AREA_LEFT, 
		    LABEL_AREA_TOP,
		    LABEL_AREA_RIGHT,
		    LABEL_AREA_BOTTOM,
		    BACKGROUND_COLOR);
     }
     if (list == NULL) {
	  return;
     }
     p = list;
     while (p != NULL) {
	  if (p->selected == 1) {
	       if (graphical_mode == True) {

		    sprintf(icon_file_name, "%s/%s.png", UIM_ICON_PATH, p->indication_id);
		    drawImage(G_LABEL_AREA_LEFT + 1, G_LABEL_AREA_TOP + 1, 
			      G_LARGE_ICON_SIZE, G_LARGE_ICON_SIZE,
			      icon_file_name);
		    dprintf("%s\n", icon_file_name);
	       } else {
		    drawnString(LABEL_AREA_LEFT+2, LABEL_AREA_BOTTOM-3,
				p->label_string,
				SELECTED_TEXT_COLOR, BACKGROUND_COLOR,
				0, 12);
	       }
	       break;
	  }
	  p = p->next;
     }
     RedrawWindow();
     return;
}

static void wmuim_draw_prop_list(wmuim_list *list)
{
     int i = 0;
     int x, y;
     int pad;
     wmuim_list *p;

     x = LIST_AREA_LEFT;
     y = LIST_AREA_BOTTOM-2;
     if (list == NULL) {
	  return;
     }
     if (graphical_mode == True) {
	  return;
     }
/*
  eraseRect(G_LIST_AREA_LEFT,
  G_LIST_AREA_TOP,
  G_LIST_AREA_RIGHT,
  G_LIST_AREA_BOTTOM,
  G_BACKGROUND_COLOR);
*/
     eraseRect(LIST_AREA_LEFT,
	       LIST_AREA_TOP,
	       LIST_AREA_RIGHT,
	       LIST_AREA_BOTTOM,
	       BACKGROUND_COLOR);

     p = list;
     while (p != NULL) {
/* a0 - df */
	  pad = 0;
	  if (p->iconic_label[0] == 0xffffff8e) {
	       pad = 4;
	  } 
	  if (p->selected == 1) {
	       if (graphical_mode == True) {
		    /* nop */
	       } else {
		    drawString(x+pad, y, p->iconic_label,
			       SELECTED_TEXT_COLOR, BACKGROUND_COLOR, 0);
	       }
	  } else {
	       if (graphical_mode == False) {
		    drawString(x+pad, y, p->iconic_label,
			       UNSELECTED_TEXT_COLOR, BACKGROUND_COLOR, 0);
	       }
	  }
	  AddMouseRegion(i + 5, x, LIST_AREA_TOP, 
			 x+strlen(p->iconic_label)*6, LIST_AREA_BOTTOM);
	  x += strlen(p->iconic_label)*6;
	  i++;
	  p = p->next;
     }
     RedrawWindow();
     return;
}

static void wmuim_draw_im_name(char *im_name)
{
     char icon_file_name[MAX_PATH_LENGTH];
     if (graphical_mode == True) {
	  sprintf(icon_file_name, "%s/%s.png",
		  UIM_ICON_PATH, im_name);
	  
	  drawImage(G_SW_AREA_LEFT+1, G_SW_AREA_TOP, G_SMALL_ICON_SIZE,
		    G_SMALL_ICON_SIZE, icon_file_name);
     } else {
	  drawImageString(SW_AREA_LEFT+1, SW_AREA_TOP,
			  im_name);
     }

     RedrawWindow();

}

int wmuim_init()
{
     uim_fd = -1;

     mode_list = NULL;
     input_list = NULL;

     if (uim_init() < 0) {
	  printf("Initializatino failed\n");
	  exit(1);
     }

     check_helper_connection();
     uim_helper_send_message(uim_fd, "im_list_get\n");
     uim_helper_client_get_prop_list();

     uim_pref_cmd = strdup(UIM_PREF);
     uim_im_switcher_cmd = strdup(UIM_IM_SWITCHER);

     return uim_fd;
}

void wmuim_set_mouse_region(void)
{
     if (graphical_mode == True) {
	  AddMouseRegion(SW_BUTTON_INDEX,
			 G_SW_AREA_LEFT,
			 G_SW_AREA_TOP,
			 G_SW_AREA_RIGHT,
			 G_SW_AREA_BOTTOM);

	  AddMouseRegion(LABEL_BUTTON_INDEX,
			 G_LABEL_AREA_LEFT,
			 G_LABEL_AREA_TOP,
			 G_LABEL_AREA_RIGHT,
			 G_LABEL_AREA_BOTTOM);

	  AddMouseRegion(INPUT_BUTTON_INDEX,
			 G_INPUT_AREA_LEFT,
			 G_INPUT_AREA_TOP,
			 G_INPUT_AREA_RIGHT,
			 G_INPUT_AREA_BOTTOM);

	  AddMouseRegion(CONFIG_BUTTON_INDEX,
			 G_CONFIG_AREA_LEFT,
			 G_CONFIG_AREA_TOP,
			 G_CONFIG_AREA_RIGHT,
			 G_CONFIG_AREA_BOTTOM);

	  AddMouseRegion(DICT_BUTTON_INDEX,
			 G_DICT_AREA_LEFT,
			 G_DICT_AREA_TOP,
			 G_DICT_AREA_RIGHT,
			 G_DICT_AREA_BOTTOM);
     } else {
	  AddMouseRegion(SW_BUTTON_INDEX,
			 SW_AREA_LEFT,
			 SW_AREA_TOP,
			 SW_AREA_RIGHT,
			 SW_AREA_BOTTOM);

	  AddMouseRegion(LABEL_BUTTON_INDEX,
			 LABEL_AREA_LEFT,
			 LABEL_AREA_TOP,
			 LABEL_AREA_RIGHT,
			 LABEL_AREA_BOTTOM);

	  AddMouseRegion(INPUT_BUTTON_INDEX,
			 INPUT_AREA_LEFT,
			 INPUT_AREA_TOP,
			 INPUT_AREA_RIGHT,
			 INPUT_AREA_BOTTOM);
     }
}

void wmuim_button_press(int buttonstatus, int button)
{
     switch(buttonstatus) {
     case SW_BUTTON_INDEX:
	  dprintf("im swithcer button pressed\n");
	  if (button == 1) {
	       system(uim_im_switcher_cmd);
	       uim_helper_send_message(uim_fd, "im_list_get\n");
	  } else if (button == 3) {
	       system(uim_pref_cmd);
	  }
	  break;
     case LABEL_BUTTON_INDEX:
	  dprintf("label button pressed\n");
	  wmuim_activate_next_item(mode_list);
	  break;
     case INPUT_BUTTON_INDEX:
	  dprintf("input button pressed\n");
	  wmuim_activate_next_item(input_list);
	  break;
     case CONFIG_BUTTON_INDEX:
	  dprintf("config button clicked\n");
	  break;
     case DICT_BUTTON_INDEX:
	  printf("dict button clicked\n");
	  break;
     case 5:
     case 6:
     case 7:
	  dprintf("unknown button clicked\n");
	  prop_menu_activate(mode_list,buttonstatus-3);
	  break;
     default:
	  dprintf("unknown button pressed\n");
	  break;
     }
}

void wmuim_periodic_function(void)
{
     if (uim_helper_fd_readable(uim_fd)) {
	  uim_fd_read_cb(uim_fd);
     }
}

