﻿using System;
using System.Collections.Generic;
using System.Text;

namespace com.ast8.fw.forms
{
    /// <summary>
    /// <seealso cref="System.Windows.Forms.TextBoxBase"/>の選択領域で使用されているものと同様の選択領域用インターフェース
    /// </summary>
    public interface MicrosoftSelectionAreaIF
    {
        /// <summary>
        /// テキスト ボックスで選択されている文字数を取得または設定します。
        /// </summary>
        int SelectionLength
        {
            get;
            set;
        }
        /// <summary>
        /// テキスト ボックスで選択されているテキストの開始点を取得または設定します。
        /// </summary>
        int SelectionStart
        {
            get;
            set;
        }
        /// <summary>
        /// コントロールで現在選択されているテキストを示す値を取得または設定します。
        /// </summary>
        string SelectedText
        {
            get;
            set;
        }

        /// <summary>
        /// テキスト ボックスでテキストの範囲を選択します。 
        /// </summary>
        /// <param name="start"></param>
        /// <param name="length"></param>
        void Select(int start, int length);

        /// <summary>
        /// テキスト ボックスのすべてのテキストを選択します。
        /// </summary>
        void SelectAll();

        /// <summary>
        /// <seealso cref="SelectionLength"/> プロパティの値を 0 にするよう指定して、コントロール内で文字が選択されないようにします。 
        /// </summary>
        void DeselectAll();

        /// <summary>
        /// テキスト ボックスの現在の選択項目をクリップボードに移動します。 
        /// </summary>
        void Cut();

        /// <summary>
        /// テキスト ボックスの現在の選択項目をクリップボードにコピーします。 
        /// </summary>
        void Copy();

        /// <summary>
        /// テキスト ボックスの現在の選択項目をクリップボードの内容と置き換えます。 
        /// </summary>
        void Paste();
    }
}
