﻿using System;
using System.Windows.Forms;

namespace com.ast8.fw.forms
{
    /// <summary>
    /// <c>System.Windows.Forms.Keys</c>列挙型に対するマジシャン
    /// </summary>
    public static class KeysMagician
    {
        /// <summary>
        /// 対象のキーが移動に使用されるキーかを判定する
        /// </summary>
        /// <remarks>
        /// 本メソッドはShift修飾も含めて判定する
        /// </remarks>
        /// <param name="key">判定するキー</param>
        /// <returns>true:移動に使用されるキー false:それ以外のキー</returns>
        public static bool isMoveKey(Keys key)
        {
            int intKey;
            if ((key & Keys.Shift) == Keys.Shift)
            {
                intKey = (int)(key ^ Keys.Shift);
            }
            else
            {
                intKey = (int)key;
            }
            if (intKey > 32 && intKey < 41)
                return true;
            return false;
        }
    }
}
