/* WinUMP.c */

/*      WinUMP  Midi plugin for Mozilla  with TiMidity++
                               Ver 0.0.1 (Pre Alpha 1)
     ------------------------------------------------------------
     Copyright (C) 2002N Keishi Suenaga
                              ----------

     {vO̓t[E\tgEFAłBȂ́AFree Software Foundation 
     \GNU ʌLgṕuo[WQv͂ȍ~̊eo[W
     ̒炢ꂩIÃo[W߂ɏ]Ė{vO
     ĔЕz܂͕ύX邱Ƃł܂B

     {vO͗LpƂ͎v܂AЕzɂẮAsꐫyѓړIK
     ɂĂ̈Öق̕ۏ؂܂߂āAȂۏ؂sȂ܂BڍׂɂĂ
     GNU ʌLgpǂ݂B

     Ȃ́A{vOƈꏏGNU ʌLgp̎ʂ󂯎Ă
     ͂łBłȂꍇ́AFree Software Foundation, Inc., 675 Mass Ave,
     Cambridge, MA 02139, USA ֎莆ĂB

     Keishi Suenaga̘A     E-mail:skeishi@users.sourceforge.jp
*/


#include <windows.h>
#include <stdio.h>                               /* sprintf(), fprintf(), etc. */
#include <fcntl.h>                               /* O_RDWR */
#include "npapi.h"

/* default library, compatible with TIMIDITY */
#ifndef DEFAULT_PATH
#define DEFAULT_PATH "c:\\timidity"
#endif /* DEFAULT_PATH */
static const char *timdir = DEFAULT_PATH;

/* resort to slow sampling rate for busy/slow processors */
static int eightKFlag = 0;
static int timid_ump_rate = 0;




static void stopMidiPlayer(PROCESS_INFORMATION ProcessInfo){
	TerminateProcess(ProcessInfo.hProcess, ProcessInfo.dwProcessId);
	WaitForSingleObject(ProcessInfo.hProcess, INFINITE);
	
	CloseHandle(ProcessInfo.hThread);
	CloseHandle(ProcessInfo.hProcess);
}




static PROCESS_INFORMATION startMidiPlayer(STARTUPINFO StartupInfo, HWND hWnd, const char *filename, int loop, int start)
{  
  	PROCESS_INFORMATION ProcessInfo;
  	LPCTSTR lpAppricationName;
	char lpCommandLine[256];
	char *stream;
  	char *opt_interface="-in";
	char opt_rate[32];

  	StartupInfo.wShowWindow = SW_SHOWNORMAL;		
	lpAppricationName = "timidity-con.exe";

	if(timid_ump_rate <= 0)
  	  stream = eightKFlag ? "-s8000": "-s22050"; /* check if the user specified 8K rate */
	else
	{
	  _snprintf(opt_rate, sizeof(opt_rate), "-s%d", timid_ump_rate);
	  stream = opt_rate;
	}

  	StartupInfo.wShowWindow = SW_SHOWNORMAL;		
	lpAppricationName = "timidity-con.exe";
  	
	_snprintf(lpCommandLine, sizeof(lpCommandLine), "%s\\timidity-con.exe -Od %s %s %s", \
		 timdir,   stream, opt_interface, filename);
  	
    chdir(timdir);
	if(! CreateProcess(lpAppricationName, lpCommandLine, \
			NULL, NULL, FALSE,CREATE_NO_WINDOW | NORMAL_PRIORITY_CLASS ,\
			NULL, NULL, &StartupInfo, &ProcessInfo )){
		MessageBox(hWnd, "Timidity vZX̍쐬Ɏs܂", 
			"Timidity vZX쐬s", MB_OK | MB_ICONERROR);
        return; 
	}  
  return ProcessInfo;
}


LRESULT CALLBACK PluginWindowProc( HWND hWnd, UINT Msg, WPARAM wParam, LPARAM lParam);
const char* gInstanceLookupString = "instance->pdata";


static const char *filestub = "c:\\tmp\\midi";

typedef enum { PLUGIN_PLAYING, PLUGIN_STOPPED, PLUGIN_PAUSED } pluginPlayState;


typedef struct _PluginInstance
{
	NPWindow*			fWindow;
	uint16				fMode;

	HWND				fhWnd;
	WNDPROC				fDefaultWindowProc;
	
	
  int fd; /* file descriptor for temp file */
  const char *filename; /* name of same */
  pluginPlayState pluginState; /* stopped, paused, or playing */
  int loop; /* 0 means play only once, non-zero means loop forever */

	PROCESS_INFORMATION ProcessInfo;
	STARTUPINFO StartupInfo;
	
} PluginInstance;	


extern int setupLiveConnect(NPP instance, PluginInstance *This);




NPError
NPP_Initialize(void)
{


  /* see if the user has specified an alternate directory for timidity */
  if(getenv("TIMID_DIR") != NULL) timdir = getenv("TIMID_DIR");
  
  /* see if the user has specified an alternate directory for timidity */
  if(getenv("TIMID_8K") != NULL) eightKFlag = 1;
  if(getenv("TIMID_RATE") != NULL) timid_ump_rate = atoi(getenv("TIMID_RATE"));

	return NPERR_NO_ERROR;
}





NPError 
NPP_New(NPMIMEType pluginType,
	NPP instance,
	uint16 mode,
	int16 argc,
	char* argn[],
	char* argv[],
	NPSavedData* saved)
{
	NPError result = NPERR_NO_ERROR;
	PluginInstance* This;
	
	if (instance == NULL) {
		return NPERR_INVALID_INSTANCE_ERROR;
	}
	instance->pdata = NPN_MemAlloc(sizeof(PluginInstance));
	This = (PluginInstance*) instance->pdata;
	if (This == NULL) {
	    return NPERR_OUT_OF_MEMORY_ERROR;
	}
	/* mode is NP_EMBED, NP_FULL, or NP_BACKGROUND (see npapi.h) */
	This->fWindow = NULL;
	This->fMode = mode;
	
	This->fhWnd = NULL;
	This->fDefaultWindowProc = NULL;




	{
    This->filename = NULL;
  	memset(&(This->StartupInfo),0,sizeof(STARTUPINFO));
	This->StartupInfo.cb = sizeof(STARTUPINFO);

    This->pluginState = PLUGIN_PLAYING;
    This->loop = 0;
  }
  
  {
    int i;
    for(i = 0; i < argc; i++) {
      if(strcasecmp(argn[i], "loop") == 0){
	if(strcasecmp(argv[i], "true") == 0 ||
	   strcasecmp(argv[i], "yes") == 0) {
	  This->loop = ~0;
	}
      }
      else if(strcasecmp(argn[i], "autostart") == 0){
	if(strcasecmp(argv[i], "false") == 0 ||
	   strcasecmp(argv[i], "no") == 0) {
	  This->pluginState = PLUGIN_STOPPED;
	}
	
      }
    }
  }
  
  (void) setupLiveConnect(instance, This);
	
	return result;
}





NPError 
NPP_Destroy(NPP instance, NPSavedData** save)
{
	PluginInstance* This;

	if (instance == NULL)
		return NPERR_INVALID_INSTANCE_ERROR;

	This = (PluginInstance*) instance->pdata;
	if( This->fWindow != NULL ) { /* If we have a window, clean
								 * it up. */
		SetWindowLong( This->fhWnd, GWL_WNDPROC, (LONG)This->fDefaultWindowProc);
		This->fDefaultWindowProc = NULL;
		This->fhWnd = NULL;
	}




	if (This != NULL) {
		if(This->filename != NULL)
    	  (void) unlink(This->filename);

		stopMidiPlayer(This->ProcessInfo);

		NPN_MemFree(instance->pdata);
		instance->pdata = NULL;
	}

	return NPERR_NO_ERROR;
}




NPError 
NPP_SetWindow(NPP instance, NPWindow* window)
{
	NPError result = NPERR_NO_ERROR;
	PluginInstance* This;

	if (instance == NULL)
		return NPERR_INVALID_INSTANCE_ERROR;

	This = (PluginInstance*) instance->pdata;


	if( This->fWindow != NULL )

	{
		if( (window == NULL) || ( window->window == NULL ) ) {

			SetWindowLong( This->fhWnd, GWL_WNDPROC, (LONG)This->fDefaultWindowProc);
			This->fDefaultWindowProc = NULL;
			This->fhWnd = NULL;
			This->fWindow=window;
			return NPERR_NO_ERROR;
		}

		else if ( This->fhWnd == (HWND) window->window ) {
			InvalidateRect( This->fhWnd, NULL, TRUE );
			UpdateWindow( This->fhWnd );
			This->fWindow=window;
			return NPERR_NO_ERROR;
		}
		else {
			SetWindowLong( This->fhWnd, GWL_WNDPROC, (LONG)This->fDefaultWindowProc);
			This->fDefaultWindowProc = NULL;
			This->fhWnd = NULL;
		}
	}
	else if( (window == NULL) || ( window->window == NULL ) ) {
		This->fWindow=window;
		return NPERR_NO_ERROR;
	}

	This->fDefaultWindowProc = (WNDPROC)SetWindowLong( (HWND)window->window, GWL_WNDPROC, (LONG)PluginWindowProc);
	This->fhWnd = (HWND) window->window;
	SetProp( This->fhWnd, gInstanceLookupString, (HANDLE)This);

	InvalidateRect( This->fhWnd, NULL, TRUE );
	UpdateWindow( This->fhWnd );
	
	This->fWindow = window;
	return result;
}

NPError 
NPP_NewStream(NPP instance,
	      NPMIMEType type,
	      NPStream *stream, 
	      NPBool seekable,
	      uint16 *stype)
{
	PluginInstance* This;

	if (instance == NULL)
		return NPERR_INVALID_INSTANCE_ERROR;

	This = (PluginInstance*) instance->pdata;
	
	
	{
	const char *ext, *p;
	static char buf[256];
	/* create template filename */
	ext = stream->url;
  	if((p = strrchr(ext, '/')) != NULL)
	  ext = p + 1;
  	if((p = strchr(ext, '.')) != NULL)
	  ext = p + 1;
  	_snprintf(buf, sizeof(buf), "%s%x.%s", filestub, This, ext);
  	This->filename = buf;

  	/* open the file to store data in */
  	unlink(This->filename);	/* for security. */
  	This->fd = open(This->filename, O_RDWR|O_CREAT|O_BINARY, 0666);
  	if(This->fd == -1) {
    	unlink(This->filename);
    	This->filename = NULL;
    	return NPERR_GENERIC_ERROR;
  	}
	}

	return NPERR_NO_ERROR;
}



int32 STREAMBUFSIZE = 0X0FFFFFFF; 




int32 
NPP_WriteReady(NPP instance, NPStream *stream)
{
	PluginInstance* This;
	if (instance != NULL)
		This = (PluginInstance*) instance->pdata;

	return STREAMBUFSIZE;
}




int32 
NPP_Write(NPP instance, NPStream *stream, int32 offset, int32 len, void *buffer)
{
	if (instance != NULL) {
		PluginInstance* This = (PluginInstance*) instance->pdata;
		len = write(This->fd, buffer, len);
      	if(len <0) close(This->fd);
	}
	return len;
}




NPError 
NPP_DestroyStream(NPP instance, NPStream *stream, NPError reason)
{
	PluginInstance* This;

	if (instance == NULL)
		return NPERR_INVALID_INSTANCE_ERROR;
	This = (PluginInstance*) instance->pdata;


  close(This->fd);
  
  stopMidiPlayer(This->ProcessInfo); 
  This->ProcessInfo = startMidiPlayer(This->StartupInfo, This->fhWnd, This->filename, This->loop, This->pluginState == PLUGIN_PLAYING);
  
  NPN_Status(instance, "Playing MIDI file");


	return NPERR_NO_ERROR;
}




void 
NPP_StreamAsFile(NPP instance, NPStream *stream, const char* fname)
{
	PluginInstance* This;
	if (instance != NULL){
		This = (PluginInstance*) instance->pdata;

		stopMidiPlayer(This->ProcessInfo);
  		This->ProcessInfo = startMidiPlayer(This->StartupInfo, This->fhWnd, fname, This->loop, This->pluginState == PLUGIN_PLAYING);
		NPN_Status(instance, "Playing MIDI file");
		
	}

}

void 
NPP_Print(NPP instance, NPPrint* printInfo)
{
	if(printInfo == NULL)
		return;

	if (instance != NULL) {
	
		if (printInfo->mode == NP_FULL) {
			printInfo->print.fullPrint.pluginPrinted = FALSE;
		}
	}
}




void
NPP_URLNotify(NPP instance, const char* url, NPReason reason, void* notifyData)
{
}





int16
NPP_HandleEvent(NPP instance, void* event)
{
	return 0;
}




LRESULT CALLBACK PluginWindowProc( HWND hWnd, UINT Msg, WPARAM wParam, LPARAM lParam)
{
	PluginInstance* This = (PluginInstance*) GetProp(hWnd, gInstanceLookupString);

	switch( Msg ) {
		case WM_PAINT: {
			PAINTSTRUCT paintStruct;
			HDC hdc;
			HBRUSH hOldBrush;
			RECT r;
			SIZE size;
			const char *text = "WinUMP";
			int textlen = strlen(text);
			hdc = BeginPaint( hWnd, &paintStruct );
			
			hOldBrush = ( HBRUSH )SelectObject( hdc, ( HBRUSH )GetStockObject( WHITE_BRUSH ));
			GetClientRect(hWnd, &r);
			Rectangle( hdc, r.left, r.top, r.right, r.bottom );
			SelectObject( hdc, hOldBrush );
			;
			GetTextExtentPoint32(hdc, text, textlen, &size);
			ExtTextOut(hdc,
				(r.right - r.left - size.cx) / 2,       /* x */
				(r.bottom - r.top - size.cy) / 2,       /* y */
				0 ,     /* fuOptions */
				&r,     /* *lprc */
				text,   /* lpszString */
				textlen,    /* cbCount */
				0 );    /* *lpdx */
			EndPaint( hWnd, &paintStruct );
			
			This->fDefaultWindowProc( hWnd, Msg, wParam, lParam);
			break;
		} 
		default: { 
			This->fDefaultWindowProc( hWnd, Msg, wParam, lParam);
		}
	} 
	return 0;
}


int setupLiveConnect(NPP instance, PluginInstance *This){return NPERR_NO_ERROR;}

jref
NPP_GetJavaClass()
{
  return NULL;
}

void
NPP_Shutdown(void)
{
}

