/*
 * Convert network-format internet address
 * to base 256 d.d.d.d representation.
 */

#ifdef __cplusplus
extern "C" {
#endif

#include <sys/types.h>

#if !defined(WIN32)
#include <netinet/in.h>
#include <arpa/inet.h>
#endif //!WIN32

#include <stdio.h>
#include <string.h>
#include <errno.h>

char *inet_ntoa_r(struct in_addr in, char *buf, int len)
{
    char b[18];
    register char *p;
    p = (char *)&in;
#define UC(b)	(((int)b)&0xff)
    snprintf(b, sizeof(b),
        "%d.%d.%d.%d", UC(p[0]), UC(p[1]), UC(p[2]), UC(p[3]));
    if (len <= (int)strlen(b))
    {
        errno = ERANGE;
        return NULL;
    }
    return strcpy(buf, b);
}

#ifdef __cplusplus
} // extern "C"
#endif

