// winterraDlg.cpp : t@C
//

#include "stdafx.h"
#include "winterra.h"
#include ".\winterradlg.h"
#include "..\\ServerLog.h"
#include "..\\HLServer.h"
#include "..\\FileUtils.h"


#ifdef _DEBUG
#define new DEBUG_NEW
#endif

// AvP[Ṽo[WɎg CAboutDlg _CAO

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

	// _CAO f[^
	enum { IDD = IDD_ABOUTBOX };

protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV T|[g

	// 
protected:
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
END_MESSAGE_MAP()


// CwinterraDlg _CAO




CwinterraDlg::CwinterraDlg(CWnd* pParent /*=NULL*/)
: CDialog(CwinterraDlg::IDD, pParent)
{
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CwinterraDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_TabCtrl, m_TabCtrl);
}

BEGIN_MESSAGE_MAP(CwinterraDlg, CDialog)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	//}}AFX_MSG_MAP
	ON_BN_CLICKED(IDC_TASKTRAY_BTN, OnTaskTrayBtn_Clicked)
	ON_WM_MOUSEMOVE()
	ON_NOTIFY(TCN_SELCHANGING, IDC_TabCtrl, OnSelchangingTabCtrl)
	ON_NOTIFY(TCN_SELCHANGE, IDC_TabCtrl, OnSelchangeTabCtrl)
	ON_WM_HELPINFO()
	ON_COMMAND(ID_OPEN_FOLDER_MENU, OnOpenFolderMenu)
	ON_COMMAND(ID_TRAY_MENU, OnTrayMenu)
	ON_COMMAND(ID_TRAY_RES, OnTrayRes)
	ON_WM_SHOWWINDOW()
	ON_WM_CLOSE()
	ON_COMMAND(ID_QUITE_MENU, OnQuiteMenu)
END_MESSAGE_MAP()



//T[o[NXbh
UINT ServerThread( LPVOID pParam )
{

	::main(NULL, NULL);//T[o[Jn

	//CButton *startBtn = (CButton*)pParam;

	//T[o[I
	//startBtn->EnableWindow( TRUE );


	return 0;
}

// CwinterraDlg bZ[W nh

BOOL CwinterraDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// "o[W..." j[VXe j[ɒǉ܂B

	// IDM_ABOUTBOX ́AVXe R}h͈͓̔ɂȂ΂Ȃ܂B
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// ̃_CAÕACRݒ肵܂BAvP[ṼC EBhE_CAOłȂꍇA
	//  Framework ́A̐ݒIɍs܂B
	SetIcon(m_hIcon, TRUE);			// 傫ACR̐ݒ
	SetIcon(m_hIcon, FALSE);		// ACR̐ݒ

	InitTrayIcon();
	InitTabPages();

	LoadWindowPos(m_hWnd);

	::log_Edit = &this->m_TabPg1.m_LogEdit;

	ServerConf mConf;
	mConf.ReloadConf();
	SetServerInfo(&mConf);


#ifdef _DEBUG
	AllocConsole();
	freopen("con","wa",stdout);
#endif//_DEBUG

	


	//Xbh
	AfxBeginThread( ServerThread , NULL );

	return TRUE;  // tH[JXRg[ɐݒ肵ꍇATRUE Ԃ܂B
}

template <class number>
string toString(number num)
{
	stringstream ss;
	string text;
	ss << num;
	ss >> text;
	return text;
}

void CwinterraDlg::SetServerInfo(ServerConf *Conf)
{
	snprintf( objTaskTrayIcon.szTip ,128 , "%s" , Conf->serverName.c_str() );
	Shell_NotifyIcon(NIM_MODIFY, &objTaskTrayIcon);

	char titleBuff[128];
	snprintf(  titleBuff , 128 , "WinTerra - %s" , Conf->serverName.c_str() );
	this->SetWindowText( titleBuff );
}



void CwinterraDlg::InitServerConfig()
{

	ServerConf conf = gServer->Config();

	m_TabPg2.m_serverName.SetWindowText	( gServer->Config().serverName.c_str() );
	m_TabPg2.m_serverDes.SetWindowText	(	gServer->Config().serverDescription.c_str() );

	m_TabPg2.m_PortNumber.SetWindowText	( toString(gServer->Config().serverPort).c_str() );
	m_TabPg2.m_maxUser.SetWindowText		(toString(gServer->Config().maxUsers).c_str() );
	m_TabPg2.m_maxDownLoad.SetWindowText(toString(gServer->Config().maxDownloads).c_str());
	m_TabPg2.m_maxUpload.SetWindowText	(toString(gServer->Config().maxUploads).c_str() );

	m_TabPg2.m_fileFolder.SetWindowText	(gServer->Config().rootPath.c_str() );
	m_TabPg2.m_agreementFile.SetWindowText( gServer->Config().agreementPath.c_str() );
	m_TabPg2.m_newsFile.SetWindowText( gServer->Config().newsPath.c_str() );
	m_TabPg2.m_AccountFolder.SetWindowText( gServer->Config().accountsPath.c_str() );
	m_TabPg2.m_logFolder.SetWindowText(gServer->Config().logsPath.c_str() );


	TrackerList::const_iterator iter = gServer->Config().trackerList.begin();
	string trackerListString;
	while (iter != gServer->Config().trackerList.end())
	{
		trackerListString.append((*iter).addr + ":" + (*iter).pass + "\r\n");
		iter++;
	}

	m_TabPg2.m_trackerList.SetWindowText( trackerListString.c_str() );




}

std::string CwinterraDlg::CstringToString(const CString *str)
{
	char *buff = new char[ str->GetAllocLength() + 1 ];
	strcpy( buff , (LPCTSTR)*str );

	std::string string(buff);

	delete [] buff;

	return string;
}

void	CwinterraDlg::SetServerConfig()
{
	CString str;


	m_TabPg2.m_serverName.GetWindowText( str );
	gServer->Config().serverName = CstringToString(&str);

	m_TabPg2.m_serverDes.GetWindowText( str );
	gServer->Config().serverDescription = CstringToString(&str);

	
	m_TabPg2.m_PortNumber.GetWindowText( str );

	if( atoi( (LPCTSTR)str ) != gServer->Config().serverPort )
	{

		AfxMessageBox("|[gԍύX܂BWinTerraċNȂΐݒ͔f܂B", 
			MB_OK|MB_ICONINFORMATION);
	}
	gServer->Config().serverPort = atoi( (LPCTSTR)str ); 

	//ŃT[o[Ȃǂ̏Zbg
	SetServerInfo(&gServer->Config());

	

	m_TabPg2.m_maxUser.GetWindowText( str );
	gServer->Config().maxUsers = atoi( (LPCTSTR)str ); 

	m_TabPg2.m_maxDownLoad.GetWindowText( str );
	gServer->Config().maxDownloads = atoi( (LPCTSTR)str ); 

	m_TabPg2.m_maxUpload.GetWindowText( str );
	gServer->Config().maxUploads = atoi( (LPCTSTR)str );


	m_TabPg2.m_fileFolder.GetWindowText( str );
	gServer->Config().rootPath = CstringToString(&str);

	m_TabPg2.m_agreementFile.GetWindowText( str );
	gServer->Config().agreementPath = CstringToString(&str);

	m_TabPg2.m_newsFile.GetWindowText( str );
	gServer->Config().newsPath = CstringToString(&str);

	m_TabPg2.m_AccountFolder.GetWindowText( str );
	gServer->Config().accountsPath = CstringToString(&str);

	m_TabPg2.m_logFolder.GetWindowText( str );
	gServer->Config().logsPath =  CstringToString(&str);

	gServer->Config().trackerList.clear();

	//gbJ[
	m_TabPg2.m_trackerList.GetWindowText( str );

	string trackerListString(CstringToString(&str));
	string trackerDelimiter = "\r\n";
	string passwordDelimiter = ":";
	vector<string> trackers;
	FileUtils::fixLineEndings(trackerListString);
	FileUtils::splitString(trackerListString, trackerDelimiter, trackers);
	vector<string>::iterator iter = trackers.begin();
	while (iter != trackers.end())
	{
		vector<string> trackerItem;
		FileUtils::splitString((*iter), passwordDelimiter, trackerItem);
		if (trackerItem.size() == 1)
		{
			string emptyString;
			gServer->Config().trackerList.push_back(TrackerEntry(trackerItem[0], emptyString));
		}
		else if (trackerItem.size() > 1)
			gServer->Config().trackerList.push_back(TrackerEntry(trackerItem[0], trackerItem[1]));
		iter++;
	}


	//save
	gServer->Config().WriteConf( gServer->Config().confFile.c_str() );

}


void CwinterraDlg::InitTrayIcon()
{
	objTaskTrayIcon.hWnd = this->m_hWnd;
	objTaskTrayIcon.uID = 0;									
	objTaskTrayIcon.uFlags = NIF_ICON | NIF_MESSAGE | NIF_TIP;
	objTaskTrayIcon.uCallbackMessage = MY_NOTIFYICON;
	objTaskTrayIcon.hIcon = this->GetIcon(false);
	lstrcpy(objTaskTrayIcon.szTip, "Winterra");
	objTaskTrayIcon.cbSize = sizeof(objTaskTrayIcon);

	Shell_NotifyIcon(NIM_ADD, &objTaskTrayIcon);
}


void CwinterraDlg::InitTabPages()
{
	TC_ITEM myTCitem;  //^uACe\
	//^uRg[ɍڂ̒ǉ
	myTCitem.mask = TCIF_TEXT;
	myTCitem.pszText = "O"; //^ǔo̐ݒ
	m_TabCtrl.InsertItem(0, &myTCitem); //^uRg[ɍڂ}
	myTCitem.pszText = "ݒ";
	m_TabCtrl.InsertItem(1, &myTCitem);
	myTCitem.pszText = "AO[g";
	m_TabCtrl.InsertItem(2, &myTCitem);
	myTCitem.pszText = "j[X";
	m_TabCtrl.InsertItem(3, &myTCitem);


	//Tab ControleEBhEƂĊe^uy[W쐬
	m_TabPg1.Create(IDD_TabPage1, &m_TabCtrl);
	m_TabPg2.Create(IDD_TabPage2, &m_TabCtrl);
	m_TabPg3.Create(IDD_TabPage3, &m_TabCtrl);
	m_TabPg4.Create(IDD_TabPage4, &m_TabCtrl);

	//\Ԃ̐ݒ
	m_TabPg1.SetWindowPos(&wndTop, 10, 30, 0, 0, SWP_NOSIZE | SWP_SHOWWINDOW);
	m_TabPg2.SetWindowPos(&wndTop, 10, 30, 0, 0, SWP_NOSIZE | SWP_HIDEWINDOW);
	m_TabPg3.SetWindowPos(&wndTop, 10, 30, 0, 0, SWP_NOSIZE | SWP_HIDEWINDOW);
	m_TabPg4.SetWindowPos(&wndTop, 10, 30, 0, 0, SWP_NOSIZE | SWP_HIDEWINDOW);

}

void CwinterraDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// _CAOɍŏ{^ǉꍇAACR`悷邽߂
//  ̃R[hKvłBhLg/r[ fg MFC AvP[V̏ꍇA
//  ́AFramework ɂĎIɐݒ肳܂B

void CwinterraDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // `̃foCX ReLXg

		SendMessage(WM_ICONERASEBKGND, reinterpret_cast<WPARAM>(dc.GetSafeHdc()), 0);

		// NCAg̎lp`̈̒
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// ACR̕`
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

//[U[ŏEBhEhbOĂƂɕ\J[\擾邽߂ɁA
//  VXe̊֐Ăяo܂B
HCURSOR CwinterraDlg::OnQueryDragIcon()
{
	return static_cast<HCURSOR>(m_hIcon);
}

void CwinterraDlg::OnTaskTrayBtn_Clicked()
{
	this->ShowWindow(0);
}



void CwinterraDlg::OnSelchangingTabCtrl(NMHDR *pNMHDR, LRESULT *pResult)
{
	int int_index = m_TabCtrl.GetCurSel(); //؂ւOTabIndexԍ
	//IꂽTab̂ݕ\B
	switch(int_index){
case 0:
	m_TabPg1.ShowWindow(SW_HIDE);
	break;
case 1:
	m_TabPg2.ShowWindow(SW_HIDE);
	break;
case 2:
	m_TabPg3.ShowWindow(SW_HIDE);
	break;
case 3:
	m_TabPg4.ShowWindow(SW_HIDE);
	break;

	}


	*pResult = 0;
}

void CwinterraDlg::OnSelchangeTabCtrl(NMHDR *pNMHDR, LRESULT *pResult)
{
	int int_index = m_TabCtrl.GetCurSel(); //؂ւTabIndexԍ
	//IꂽTab̂ݕ\B
	switch(int_index){
case 0:
	m_TabPg1.ShowWindow(SW_SHOW);
	break;
case 1:
	InitServerConfig();
	m_TabPg2.ShowWindow(SW_SHOW);
	break;
case 2:
	showAgreement();
	m_TabPg3.ShowWindow(SW_SHOW);
	break;
case 3:
	showNews();
	m_TabPg4.ShowWindow(SW_SHOW);
	break;

	}



	*pResult = 0;
}

BOOL CwinterraDlg::PreTranslateMessage(MSG* pMsg)
{

	if(pMsg->message == WM_KEYDOWN)
	{
		if(pMsg->wParam == VK_RETURN ||
			pMsg->wParam == VK_ESCAPE)
		{
			return FALSE;
		}
	}
	return CDialog::PreTranslateMessage(pMsg);
}

BOOL CwinterraDlg::OnHelpInfo(HELPINFO* pHelpInfo)
{
	//return CDialog::OnHelpInfo(pHelpInfo);
	return FALSE;
}

CwinterraDlg::~CwinterraDlg()
{
}

void CwinterraDlg::OnOpenFolderMenu()
{
	char path[MAX_PATH];
	FileUtils::getAbsolutPath(gServer->Config().rootPath.c_str() , path);
	ShellExecute(0,"open",
		path,
		NULL,NULL,
		SW_SHOWNORMAL);
}

void CwinterraDlg::OnTrayMenu()
{
	OnTaskTrayBtn_Clicked();
}




void CwinterraDlg::showAgreement()
{
	std::string agree;
	gServer->getDataBase()->GetAgreement( agree );
	string p("\r");
	string pl("\r\n");
	agree = FileUtils::replace_all_target( agree , p , pl );
	m_TabPg3.m_agreeEdit.SetWindowText( agree.c_str() );
}

void CwinterraDlg::showNews()
{
	std::string news;
	gServer->getDataBase()->GetNewsFile( news );
	string p("\r");
	string pl("\r\n");
	news = FileUtils::replace_all_target( news , p , pl );
	m_TabPg4.m_NewsEdit.SetWindowText( news.c_str() );
}


void CwinterraDlg::OnTrayRes()
{
	this->ShowWindow(1);
	this->SetForegroundWindow();
}

LRESULT CwinterraDlg::WindowProc(UINT message, WPARAM wParam, LPARAM lParam) 
{
	switch (message) {
		case MY_NOTIFYICON:
			switch (lParam) {
		case WM_MOUSEMOVE:
			break;
		case WM_LBUTTONDBLCLK:
			break;
		case WM_LBUTTONDOWN:
			if( this->IsWindowVisible())
			{
				this->ShowWindow(0);
			}
			else
			{
				this->ShowWindow(1);
				this->SetForegroundWindow();
			}
			break;
		case WM_LBUTTONUP:
			break;
		case WM_RBUTTONDBLCLK:
			break;
		case WM_RBUTTONUP:
			break;
		case WM_RBUTTONDOWN:
			this->SetForegroundWindow();
			this->SetFocus();


			CMenu menu;
			VERIFY(menu.LoadMenu(IDR_NOTIFY_MENU));
			CMenu* pPopup = menu.GetSubMenu(0);
			ASSERT(pPopup != NULL);

			if( !this->IsWindowVisible() )
			{
				pPopup->RemoveMenu( ID_TRAY_MENU , MF_BYCOMMAND );
			}
			else
			{
				pPopup->RemoveMenu( ID_TRAY_RES , MF_BYCOMMAND );
			}

			POINT p;
			GetCursorPos( &p );
			pPopup->TrackPopupMenu( TPM_LEFTALIGN | TPM_RIGHTBUTTON,
				p.x, p.y, this);


			PostMessage( WM_NULL );
			break;
			}
			break;
	}
	return CDialog::WindowProc(message, wParam, lParam);
}



char *CwinterraDlg::GetIniFilePath()
{
	char *lpResult;
	char *lpPoint;

	lpResult = new char[MAX_PATH];
	GetCurrentDirectory(MAX_PATH,lpResult);
	sprintf( lpResult , "%s\\data\\winterra.ini" ,lpResult );
	return lpResult;
}


void CwinterraDlg::SaveWindowPos(HWND hWnd)
{
	char *lpIniFilePath;
	lpIniFilePath = GetIniFilePath();

	WINDOWPLACEMENT wp;
	::GetWindowPlacement(hWnd, &wp);

	char lpSet[33];
	ltoa(wp.rcNormalPosition.left	, lpSet, 10);
	WritePrivateProfileString("WinPos", "left"	 , lpSet, lpIniFilePath);
	ltoa(wp.rcNormalPosition.right	, lpSet, 10);
	WritePrivateProfileString("WinPos", "right"	 , lpSet, lpIniFilePath);
	ltoa(wp.rcNormalPosition.top	, lpSet, 10);
	WritePrivateProfileString("WinPos", "top"	 , lpSet, lpIniFilePath);
	ltoa(wp.rcNormalPosition.bottom	, lpSet, 10);
	WritePrivateProfileString("WinPos", "bottom" , lpSet, lpIniFilePath);
	ltoa(wp.showCmd					, lpSet, 10);
	WritePrivateProfileString("WinPos", "showCmd", lpSet, lpIniFilePath);

	delete [] lpIniFilePath;
}

void CwinterraDlg::LoadWindowPos(HWND hWnd)
{
	::ShowWindow(hWnd, SW_MINIMIZE);

	char *lpIniFilePath;
	lpIniFilePath = GetIniFilePath();

	WINDOWPLACEMENT wp;
	::GetWindowPlacement(hWnd, &wp);

	char lpDef[33];
	char lpRes[33];

	ltoa(wp.rcNormalPosition.left	, lpDef, 10);
	GetPrivateProfileString("WinPos", "left"   , lpDef, lpRes, 33, lpIniFilePath);
	wp.rcNormalPosition.left	= atol(lpRes);

	ltoa(wp.rcNormalPosition.right	, lpDef, 10);
	GetPrivateProfileString("WinPos", "right"  , lpDef, lpRes, 33, lpIniFilePath);
	wp.rcNormalPosition.right	= atol(lpRes);

	ltoa(wp.rcNormalPosition.top	, lpDef, 10);
	GetPrivateProfileString("WinPos", "top"	   , lpDef, lpRes, 33, lpIniFilePath);
	wp.rcNormalPosition.top		= atol(lpRes);

	ltoa(wp.rcNormalPosition.bottom	, lpDef, 10);
	GetPrivateProfileString("WinPos", "bottom" , lpDef, lpRes, 33, lpIniFilePath);
	wp.rcNormalPosition.bottom	= atol(lpRes);

	ltoa(wp.showCmd					, lpDef, 10);
	GetPrivateProfileString("WinPos", "showCmd", lpDef, lpRes, 33, lpIniFilePath);
	wp.showCmd					= atol(lpRes);

	::SetWindowPlacement(hWnd, &wp);

	delete [] lpIniFilePath;
}


void CwinterraDlg::OnShowWindow(BOOL bShow, UINT nStatus)
{
	CDialog::OnShowWindow(bShow, nStatus);

	//if (bShow)
	//{
	//	LoadWindowPos(m_hWnd);
	//}
}

void CwinterraDlg::OnClose()
{
	int ret = -1;
	ret = AfxMessageBox("IĂ낵łH", MB_OKCANCEL|MB_ICONWARNING);
	if( IDCANCEL == ret )
	{
		return;
	}
	gServer->Stop();
#ifdef _DEBUG
	FreeConsole();
#endif
SaveWindowPos(this->m_hWnd);
	CDialog::OnClose();
}

void CwinterraDlg::OnQuiteMenu()
{
	::SendMessage(this->m_hWnd ,  WM_CLOSE , 0 , 0 );
}
