#include "SocketSelector.h"
#include "AsyncTCPSocket.h"
#include <sys/types.h>

#if !defined(WIN32)
#include <sys/time.h>
#include <sys/errno.h>
#include <unistd.h>
#endif // !WIN32

SocketSelector::SocketSelector()
    : mListModified(false)
{
}

SocketSelector::~SocketSelector()
{
}

void SocketSelector::AddSocket(AsyncTCPSocket &inSocket)
{
    mListModified = true;
    mSocketList.push_back(&inSocket);
}

void SocketSelector::RemoveSocket(AsyncTCPSocket &inSocket)
{
    mListModified = true;
    mSocketList.remove(&inSocket);
}

void SocketSelector::WaitEvent(time_t inSeconds)
{
    int maxFd = 0;
    fd_set readSet, writeSet, exceptSet;
    SocketList::iterator iter = mSocketList.begin();
    
    FD_ZERO(&readSet);
    FD_ZERO(&writeSet);
    FD_ZERO(&exceptSet);
    
    while (iter != mSocketList.end())
    {
        if ((*iter)->mWaitRead)
            FD_SET((*iter)->Descriptor(), &readSet);
        
        if ((*iter)->mWaitWrite)
		{
			FD_SET((*iter)->Descriptor(), &writeSet);
			FD_SET((*iter)->Descriptor(), &exceptSet);
		}
		
        if ((*iter)->Descriptor() > maxFd)
            maxFd = (*iter)->Descriptor();
            
        iter++;
    }
    
    int err;
    if (inSeconds)
    {
        struct timeval tv;
        tv.tv_sec = inSeconds;
        tv.tv_usec = 0;
        
        err = select(maxFd + 1, &readSet, &writeSet, &exceptSet, &tv);
    }
    else
    {
        err = select(maxFd + 1, &readSet, &writeSet, &exceptSet, NULL);
    }
    
    if (err > 0)
    {
        iter = mSocketList.begin();
        int counter = 0;
        while (iter != mSocketList.end() && counter < err)
        {
            // we always start with a clean list, it can be modified in the callbacks
            mListModified = false;
            
            if ((*iter)->mWaitRead)
            {
                if (FD_ISSET((*iter)->Descriptor(), &readSet))
                {
                    counter++;
                    FD_CLR((*iter)->Descriptor(), &readSet);
                    if ((*iter)->mListening)
                    {
                        (*iter)->OnAccept();
                    }
					else if ((*iter)->GetAvailBytes() == 0)
                    {
                        (*iter)->Close();
                    }
                    else
                    {
                        (*iter)->OnRecv();
                    }
                }
            }
            
            if (!mListModified)
            {
                if ((*iter)->mWaitWrite)
                {
                    if (FD_ISSET((*iter)->Descriptor(), &writeSet))
                    {
                        counter++;
                        FD_CLR((*iter)->Descriptor(), &writeSet);
                        (*iter)->mWaitWrite = false;
                        if (!(*iter)->mConnected)
						{
							// i attempted checking the exceptSet here,
							// but it didn't seem to work, so i'm doing this instead
							if ((*iter)->GetError() == 0)
							{
								DEBUG_CALL(printf("calling on connect\n"));
								(*iter)->mConnected = true;
								(*iter)->mWaitRead = true;
								(*iter)->OnConnect();
							}
							else
							{
								DEBUG_CALL(printf("calling onClose, connect failed\n"));
								(*iter)->OnClose(); // connect failed
							}
						}
						else
							(*iter)->OnSend();
                    }
                }
            }
            
            // if the list gets modified then we must reset the iterator
            if (mListModified)
                iter = mSocketList.begin();
            else
                iter++;
        }
    }
    else if (err != 0)
    {
        DEBUG_CALL(printf("select error: %d\n", errno); fflush(stdout));
    }
}

