/*
 *  ServerLink.h
 *  
 *
 *  Created by Jason Toffaletti on Sat Apr 26 2003.
 *  Copyright (c) 2003 __MyCompanyName__. All rights reserved.
 *
 */
#if defined(CONFIG_LINKING)

#ifndef SERVER_LINK_H
#define SERVER_LINK_H

#include "BufferedSocket.h"
#include "message/message.hpp"
#include <sstream>

using namespace std;
using namespace flat;

typedef jason::message<uint8, flattenable_uint8> jmessage;

class LinkSocketCallback;

class LinkSocket : public BufferedSocket
{
public:
	LinkSocket(LinkSocketCallback *inCallback = NULL);

protected:
	void SendJMessage(jmessage &inMsg);
	
	void DataAvailable();
	void OnConnect();
	void OnClose();
	
	LinkSocketCallback *mCallback;

friend class LinkManager;
};

class LinkSocketCallback
{
	protected:
		virtual void HandleConnect() {}
		virtual void HandleClose() {}
		virtual void ProcessJMessage(LinkSocket &inSocket, jmessage &inMsg)
			{ (void)inSocket; (void)inMsg; }

friend class LinkSocket;
};

class HLClient;

class LinkManager : public LinkSocketCallback
{
public:
	LinkManager();
	virtual ~LinkManager() {}
	
	void EstablishLinkWithHub(const string &inAddress, u_int16_t inPort);	
	//void BroadcastClientLogin(HLClient &inClient);
	//void BroadcastClientLeave(HLClient &inClient);
	void LinkChat(HLClient &inClient, unsigned int inStyle, const string &inChat);
	void LinkBroadcast(const string &inBroadcast);
	void LinkMessage(HLClient &sendClient, HLClient &toClient, const string &inMessage);
	void LinkUserJoin(HLClient &inClient);
	void LinkUserChange(HLClient &inClient);
	void LinkUserLeave(HLClient &inClient);

protected:
	void HandleConnect();
	void HandleClose();
	void ProcessJMessage(LinkSocket &inSocket, jmessage &inMsg);
	
	void HandleChat(jmessage &inMsg);
	void HandleBroadcast(jmessage &inMsg);
	void HandleMessage(jmessage &inMsg);
	void HandleSetGuid(jmessage &inMsg);
	void HandleUserJoin(jmessage &inMsg);
	void HandleUserLeave(jmessage &inMsg);
	void HandleUserChange(jmessage &inMsg);
	
	LinkSocket mLinkSocket;
};

#endif // SERVER_LINK_H

#endif // CONFIG_LINKING

