// This is for detecting hosts that are connecting via a SOCKS proxy
// The default behavior for the server is to ban these hosts, but
// I might add an option to turn that off and just have it log the information.

#ifndef SOCKS_THREAD_H
#define SOCKS_THREAD_H

#include "BThread.h"
#include <string>

#if !defined(WIN32)
#include <netinet/in.h>
#endif // !WIN32

using namespace std;

// this is a thread that will tell you
// if a host is running a SOCKS proxy
// the source is taken from tsocks 1.8beta4

class InspectSOCKSCallback
{
	protected:
		virtual void FoundSOCKSHost(const string &inAddress, int inVersion) = 0;
friend class InspectSOCKSThread;
};

class InspectSOCKSThread : public BThread
{
	public:
		InspectSOCKSThread(const string &inAddress, InspectSOCKSCallback &inCallback);
		~InspectSOCKSThread();
	
	private:
		void Run();
		int SendRequest(struct sockaddr_in *server,
			void *req, int reqlen, void *rep, int replen);
		
		string mAddress;
		InspectSOCKSCallback &mCallback;
};

#endif // SOCKS_THREAD_H
