#ifndef HLUSERDATA_H
#define HLUSERDATA_H
// This class handles reading and writing Hotline UserData files
// It is very similar to the HLAccount class, which is more abstract

#include "HLProtocol.h"
#include <string>

using namespace std;

class HLUserData
{
    public:
        HLUserData(const string &inLogin);
        ~HLUserData();
        
        bool ReadFrom(const string &inAccountsDir);
        void WriteTo(const string &inAccountsDir, bool inCreate);
        void DeleteFrom(const string &inAccountsDir);
        
        const string &Login() const
            { return mLogin; }
        
        const string &Name() const
            { return mName; }
        
        const string &Password() const
            { return mPassword; }
        
        const string &RootPath() const
            { return mRootPath; }
        
        const struct hl_access_bits &AccessBits() const
            { return mAccessBits; }
        
        const u_int32_t MaxBps() const
            { return mMaxBps; }
        
        void SetName(const string &inName)
            { mName = inName; }
        
        void SetPassword(const string &inPassword)
            { mPassword = inPassword; }
        
        void SetRootPath(const string &inRootPath)
            { mRootPath = inRootPath; }
        
        void SetAccessBits(const struct hl_access_bits &inAccessBits)
            { mAccessBits = inAccessBits; }
        
        void SetMaxBps(const u_int32_t inMaxBps)
            { mMaxBps = inMaxBps; }
        
    private:
        string mLogin;
        string mName;
        string mPassword;
        string mRootPath;
        struct hl_access_bits mAccessBits;
        u_int32_t mMaxBps;
};

#endif // HL_USERDATA_H
