#include "HLObject.h"
#include "HLProtocol.h"
#include "dirchar.h"
#include "HLEncrypt.h"

#if !defined(WIN32)
#include <arpa/inet.h>
#endif // !WIN32

HLObject::HLObject(u_int16_t inType, u_int16_t inSize, const char *inData)
    : mType(inType), mSize(inSize)
{
    mData = new char[inSize];
    memcpy(mData, inData, inSize);
}

/* copy constructor */
HLObject::HLObject(const HLObject &inObj)
    : mType(inObj.mType), mSize(inObj.mSize)
{
    mData = new char[inObj.mSize];
    memcpy(mData, inObj.mData, inObj.mSize);
}

HLObject::~HLObject()
{
    delete[] mData;
}

const char *HLObject::GetData() const
{
    return mData;
}

u_int16_t HLObject::GetType() const
{
    return mType;
}

u_int16_t HLObject::GetSize() const
{
    return mSize;
}

void HLObject::GetDataAsString(string& outString, u_int32_t inMaxLen) const
{
    if (inMaxLen != 0 && mSize > inMaxLen)
        outString.assign(mData, inMaxLen);
    else
        outString.assign(mData, mSize);
}

void HLObject::GetDataAsPathVector(PathVector &outPathVector) const
{
    outPathVector.clear();
    if ((mType == HTLC_DATA_DIR ||
        mType == HTLC_DATA_DIR_RENAME ||
        mType == HTLC_DATA_NEWS_DIR) &&
        mSize > 5)
    {
        u_int16_t pos = 0;
        u_int16_t dirLevels = ntohs(*((u_int16_t *)&mData[pos]));
        pos += sizeof(u_int16_t);
        pos++;
        
        outPathVector.reserve(dirLevels);
        
        while (pos < mSize && dirLevels)
        {
            u_int16_t dirNameLen = ntohs(*((u_int16_t *)&mData[pos]));
            pos += sizeof(u_int16_t);
            if (!(dirNameLen == 2 && mData[pos] == '.' && mData[pos + 1] == '.')
                && !memchr(&mData[pos], DIRCHAR, dirNameLen))
            {
                string pathComponent(&mData[pos], dirNameLen);
                outPathVector.push_back(pathComponent);
                pos += dirNameLen + 1;
                dirLevels--;
            }
            else
            {
                // person trying to hack the paths
                outPathVector.clear();
                return;
            }
        }
    }
}

void HLObject::GetDataResumeSizes(u_int32_t &outDataForkSize,
	u_int32_t &outResourceForkSize) const
{
    outDataForkSize = 0;
    outResourceForkSize = 0;
    if (mSize > SIZEOF_RESUME_DATA)
    {
        struct resume_data *resumeData = (struct resume_data *)mData;
        if (resumeData->magic == htonl(0x52464C54)) // 'RFLT'
        {
            u_int16_t counter = 0;
            u_int16_t pos = SIZEOF_RESUME_DATA;

						//2003/07/27 added by ortana.
						BOOL dfSize = FALSE;
						BOOL rfSize = FALSE;
            while (counter < resumeData->hc)//value of hc is "512".on Win32.
            {
                struct fork_data *forkData = (struct fork_data *)&mData[pos];
                if (forkData->type == htonl(0x44415441)) // 'DATA'
                {
                    outDataForkSize = ntohl(forkData->len);
										dfSize = TRUE;
                }
                else if (forkData->type == htonl(0x4D414352)) // 'MACR'
                {
                    outResourceForkSize = ntohl(forkData->len);
										rfSize = TRUE;
                }

								if( dfSize == TRUE && rfSize == TRUE )
								{
									break;
								}
						
                pos += SIZEOF_FORK_DATA;
                counter++;
            }
        }
    }
}

u_int32_t HLObject::GetDataAsUInt32() const
{
    if (mSize >= 4)
        return ntohl(*((u_int32_t *)mData));
    else if (mSize == 2)
        return (u_int32_t)ntohs(*((u_int16_t *)mData));
    else if (mSize == 1)
        return (u_int32_t)*((u_int8_t *)mData);
    else
        return 0; // this is bad...
}

u_int16_t HLObject::GetDataAsUInt16() const
{
    return (u_int16_t)GetDataAsUInt32();
}

u_int8_t HLObject::GetDataAsUInt8() const
{
    return (u_int8_t)mData[0];
}

void HLObject::GetDataAsObjectList(HLObjectList &outObjectList) const
{
	outObjectList.Instantiate(mData, mSize);
	/*
	outObjectList.clear();
	u_int16_t pos = 0;
	u_int16_t objCount = ntohs(*((u_int16_t *)&mData[pos]));
	pos += sizeof(u_int16_t);
	while (pos < mSize && objCount)
	{
		HL_OBJECT_HEADER *o_hdr = (HL_OBJECT_HEADER *)&mData[pos];
		u_int16_t size = ntohs(o_hdr->size);
		if (size + pos <= mSize)
		{
			HLObject *newObject = new HLObject(ntohs(o_hdr->type), size, (const char *)o_hdr->data);
			outObjectList.push_back(newObject);
		}
		else
			// error
			return;
		pos += size + 4;
		objCount--;
	}
	*/
}

void HLObject::Encrypt()
{
    HLEncrypt((u_int8_t *)mData, mSize);
}

void HLEncrypt(u_int8_t *ioData, u_int32_t inSize)
{
    u_int32_t pos = inSize;
    while (pos)
    {
        pos--;
        ioData[pos] = 255 - ioData[pos];
    }
}

