#ifndef MDNS_REGISTRAR_H
#define MDNS_REGISTRAR_H

#if defined(CONFIG_RENDEZVOUS)
#include <list>
#include "BThread.h"
#include "BCondition.h"
#include "BMutex.h"
#include <CoreFoundation/CoreFoundation.h>
#include <DNSServiceDiscovery/DNSServiceDiscovery.h>

using namespace std;

class DNSServiceRegistrarCallback
{
    protected:
        virtual void RegisterReply(const string &inServiceName, int inErrorCode) = 0;
        
    friend class DNSServiceRegistrar;
};

struct ServiceRecord
{
    string serviceName;
    string serviceType;
    string serviceDomain;
    u_int16_t servicePort;
    dns_service_discovery_ref dnsClient;
    DNSServiceRegistrarCallback *callback;
};
typedef struct ServiceRecord ServiceRecord;
typedef list<ServiceRecord *> RegisteredServicesList;

class DNSServiceRegistrar : public BThread
{
    public:
        DNSServiceRegistrar();
        ~DNSServiceRegistrar();
        
        void RegisterService(const string &inServiceName, const string &inServiceType,
            const string &inServiceDomain, const u_int16_t inServicePort,
            DNSServiceRegistrarCallback *inCallback);
        void UnregisterService(const string &inServiceName);
    
    protected:
        void Run();
        
    private:
        
        static void PrivateRegisterReply(int inErrorCode, void *inContext);
        static void dumbyTimer(CFRunLoopTimerRef, void *);
        static RegisteredServicesList mRegisteredList;
        static BMutex mLock;
        static BCondition *mCondition;
        static CFRunLoopRef mRunLoop;
};

#endif // CONFIG_RENDEZVOUS

#endif // MDNS_REGISTRAR_H