#include "BufferedSocket.h"

BufferedSocket::BufferedSocket()
	: AsyncTCPSocket()
{
}

BufferedSocket::BufferedSocket(int inDescriptor, struct sockaddr_in* inRemoteAddress)
    : AsyncTCPSocket(inDescriptor, inRemoteAddress)
{
}

BufferedSocket::~BufferedSocket()
{
    Shutdown();
    Close();
}

void BufferedSocket::OnRecv()
{
    int recvSize = GetAvailBytes();
    
    size_t bufPos = mReadBuf.Size();
    mReadBuf.Resize(bufPos + recvSize);
    int totalRecv = 0;
	
	while (totalRecv != recvSize)
	{
		int status = Recv(mReadBuf.Ptr(bufPos + totalRecv), recvSize);
	
		if (status == -1)
		{
			DEBUG_CALL(printf("error from Recv() in BufferedSocket::OnRecv: %s\n",
				strerror(errno)));
			Close();
			return;
		}
		else
			totalRecv += status;
	}

    DataAvailable();
}

void BufferedSocket::OnSend()
{
    // there is data in the buffer waiting to be sent
    try
    {
        if (mWriteBuf.Size())
        {
            int sentSize = AsyncTCPSocket::Send(mWriteBuf.Ptr(), mWriteBuf.Size());
            if ((size_t)sentSize != mWriteBuf.Size())
            {
                mWriteBuf.RemoveFrom(sentSize);
            }
            else
            {
                mWriteBuf.Resize(0);
            }
        }
        else
        {
            DEBUG_CALL(printf("got OnSend, but no data in buffer\n"); fflush(stdout));
        }
    }
    catch (socket_error &exp)
    {
        DEBUG_CALL(printf("BufferedSocket::OnSend() socket_error(%d): %s\n", 
            exp.error_code(), exp.what()); fflush(stdout));
        Shutdown();
        Close();
    }
}

void BufferedSocket::OnClose()
{
    // free memory
    mWriteBuf.Resize(0);
    mReadBuf.Resize(0);
}

void BufferedSocket::BufferedSend(const char *inBytes, u_int32_t inCount)
{
    if (mWaitWrite)
    {
        // data goes straight to buffer
        mWriteBuf.CopyInto(inBytes, inCount);
    }
    else
    {
        int sentSize = AsyncTCPSocket::Send(inBytes, inCount);
        if ((size_t)sentSize != inCount)
        {
            // copy unsent data into buffer for sending later
            mWriteBuf.CopyInto(&inBytes[sentSize], (inCount - sentSize));
        }
    }
}
