/////////////////////////////////////////////////////////////////////////////
//    License (GPLv2+):
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful, but
//    WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//    General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program; if not, write to the Free Software
//    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
/////////////////////////////////////////////////////////////////////////////
/** 
 * @file  ProjectFile.h
 *
 * @brief Declaration file ProjectFile class
 */
// RCS ID line follows -- this is updated by CVS
// $Id: ProjectFile.h 4619 2007-10-14 08:50:20Z jtuc $

#include <scew/scew.h>
#include "PathContext.h"

/** @brief File extension for path files */
const TCHAR PROJECTFILE_EXT[] = _T("WinMerge");

/**
 * @brief Class for handling project files.
 *
 * This class loads and saves project files. Expat parser and SCEW wrapper for
 * expat are used for XML parsing. We use UTF-8 encoding so Unicode paths are
 * supported.
 */
class ProjectFile
{
public:
	ProjectFile();
	BOOL Read(LPCTSTR path, String *sError);
	BOOL Save(LPCTSTR path, String *sError);
	
	BOOL HasLeft() const;
	BOOL HasMiddle() const;
	BOOL HasRight() const;
	BOOL HasFilter() const;
	BOOL HasSubfolders() const;

	CString GetLeft(BOOL * pReadOnly = NULL) const;
	BOOL GetLeftReadOnly() const;
	CString GetMiddle(BOOL * pReadOnly = NULL) const;
	BOOL GetMiddleReadOnly() const;
	CString GetMiddle() const;
	CString GetRight(BOOL * pReadOnly = NULL) const;
	BOOL GetRightReadOnly() const;
	CString GetFilter() const;
	int GetSubfolders() const;

	CString SetLeft(const CString& sLeft, const BOOL * pReadOnly = NULL);
	CString SetMiddle(const CString& sMiddle, const BOOL * pReadOnly = NULL);
	CString SetRight(const CString& sRight, const BOOL * pReadOnly = NULL);
	CString SetFilter(const CString& sFilter);
	int SetSubfolders(int iSubfolder);

	void GetPaths(PathContext& files, BOOL & bSubFolders) const;
	void SetPaths(const PathContext& files, BOOL bSubFolders = FALSE);

protected:
	scew_element* GetRootElement(scew_tree * tree);
	BOOL GetPathsData(scew_element * parent);

	scew_element* AddPathsElement(scew_element * parent);
	BOOL AddPathsContent(scew_element * parent);

private:
	PathContext m_paths;
	BOOL m_bHasLeft; /**< Has left path? */
	BOOL m_bHasMiddle; /**< Has middle path? */
	BOOL m_bHasRight; /**< Has right path? */
	BOOL m_bHasFilter; /**< Has filter? */
	CString m_filter; /**< Filter name or mask */
	BOOL m_bHasSubfolders; /**< Has subfolders? */
	int m_subfolders; /**< Are subfolders included (recursive scan) */
	BOOL m_bLeftReadOnly; /**< Is left path opened as read-only */
	BOOL m_bMiddleReadOnly; /**< Is middle path opened as read-only */
	BOOL m_bRightReadOnly; /**< Is right path opened as read-only */
};
