//
// Copyright (C) 1999-2002 Toshikaz Hirabayashi
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// TOSHIKAZ HIRABAYASHI BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
// WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF
// OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//
// Except as contained in this notice, the name of Toshikaz Hirabayashi shall
// not be used in advertising or otherwise to promote the sale, use or other
// dealings in this Software without prior written authorization from
// Toshikaz Hirabayashi.

#include <WScom.h>
#include <WSCtform.h>
#include <WSCclassInformation.h>
#include <WSCdevice.h>
#include <WSDdev.h>
#include <WSCfontSet.h>
#include <WSCvradio.h>

WSMFguiClassInitialize(WSCtform,WSCform);
WSMFversion(WSCtform,WSCform);

WSMFpropertyValueChange( WSCtform, WSNshadowType , char,WS_SHADOW_EIN);

WSCtform::WSCtform(WSCbase* base,char* objname):
                WSCform(base,objname){

  _title_string = WSGFstrdup("");
  _font = (char)WSGIappFontSet()->getDefaultFontNo();
  _shadow_type = WS_SHADOW_EIN;

  WSMFpropertyCreateStart
    WSMFparentCheckVerSrc(WSCtform);

    WSMFpropertyCreate(WSNtitleString,char*,_title_string,WSStitleString);
    WSMFpropertyCreate(WSNfont,         WSCuchar,   _font,WSSfont  );

    WSMFpropertyValueChangeDef( WSCtform,WSNshadowType ,char);

    WSMFaddTrigger(WSEV_VALUE_CH    );

  WSMFpropertyCreateEnd

}

WSMFproperty(WSCtform,WSNtitleString,char*,_title_string,WSGFstrdup(""));
WSMFproperty(WSCtform,WSNfont, WSCuchar, _font,(char)WSGIappFontSet()->getDefaultFontNo());


void WSCtform::setWorkWSNtitleString(char*){}
void WSCtform::getWorkWSNtitleString(char**){}
void WSCtform::setWorkWSNfont(WSCuchar){}
void WSCtform::getWorkWSNfont(WSCuchar*){}

WSCtform::~WSCtform(){
  if (_title_string != NULL){
    delete _title_string;
    _title_string = NULL;
  }
}

long WSCtform::draw(){

  if (_no_refresh != False){
    WSCbase::update();
    setAbsoluteDraw(False);
    return WS_NO_ERR;
  }
  if (getVisible() == False){
    return WS_NO_ERR;
  }

  WSDdev* dev = getowndev();
  if (dev == NULL){
    return WS_ERR;
  }

  WSCbool absolute = getAbsoluteDraw();
  if (absolute == False  ){
    if ( dev->isExposed(0,0,_w,_h) == False ){
      return WS_NO_ERR;
    }
  }
  long err = dev->beginDraw(0,0,_w,_h,absolute);
  if (err != WS_NO_ERR){
    return WS_NO_ERR;
  }
  short ex = 0;
  short ey = 0;
  WSCushort ew = _w;
  WSCushort eh = _h;
  if (absolute == False){
    dev->getExposedArea(&ex,&ey,&ew,&eh);
  }
  WSCbase::update();
  setAbsoluteDraw(False);
  if (_bp_color == -1){
    if (_grad_no == 0){
      dev->setForeColor(_back_color);
      dev->drawFillRect(0,0,_w,_h);
    }else{
      dev->drawGradation(_grad_no,_ts_color,_back_color,_bs_color,0,0,_w,_h,_grad_margin);
    }
  }
  if (getDotMode() == True){
    dev->setForeColor(_fore_color);
    long i,j;
    for(i=0; i<_w; i+=10){
      for(j=0; j<_h; j+=10){
        if (ex < i && i < ex+ ew &&
            ey < j && j < ey+ eh ){
          dev->drawFillRect(i,j,1,1);
        }
      }
    }
  }

  WSDfont* fn = WSGIappFontSet()->getFont(_font);
  WSCstring tmp;
  tmp << " " << (_title_string);
  tmp << " ";
  long fw = fn->getStringWidth(&tmp); 
  long fh = fn->getStringHeight(&tmp); 
  WSGFdrawShadow(dev,_shadow_type,_shadow_thick,_fore_color,
                 _ts_color,_bs_color,_back_color,fh/2,fh/2,_w-fh/2,_h-fh/2);

  dev->setForeColor(_fore_color);
  dev->setBackColor(_back_color);
  dev->drawFillString(fh, 1, fw, fh, &tmp, _font, WS_CENTER,-1,0);

  dev->endDraw();
  return WS_NO_ERR;
}

