//
// Copyright (C) 1999-2002 Toshikaz Hirabayashi
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// TOSHIKAZ HIRABAYASHI BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
// WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF
// OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//
// Except as contained in this notice, the name of Toshikaz Hirabayashi shall
// not be used in advertising or otherwise to promote the sale, use or other
// dealings in this Software without prior written authorization from
// Toshikaz Hirabayashi.

#include <WScom.h>
#include <WSCpopupFrame.h>
#include <WSCclassInformation.h>
#include <WSCdevice.h>
#include <WSDdev.h>
#include <WSDmouse.h>
#include <WSCfontSet.h>
#include <WSCcolorSet.h>
#include <WSDappDev.h>

WSMFguiClassInitialize(WSCpopupFrame, WSCwindow);

WSMFpropertyValueChange(WSCpopupFrame,WSNforeColor,short,WS_DF_MENUFORECOLOR);
WSMFpropertyValueChange(WSCpopupFrame,WSNbackColor,short,WS_DF_MENUBACKCOLOR);
WSMFpropertyValueChange(WSCpopupFrame,WSNtopShadowColor,short,WS_DF_MENUTOPSHADOWCOLOR);
WSMFpropertyValueChange(WSCpopupFrame,WSNbottomShadowColor,short,WS_DF_MENUBOTTOMSHADOWCOLOR);


WSCpopupFrame::WSCpopupFrame(WSCbase* base, char* objname):
                WSCwindow(base, objname){

  _status_array = NULL;
  _menu_str = WSGFstrdup(""); 
  _item_height = 30; 
  _font = (char)WSGIappFontSet()->getDefaultFontNo(); 

  _fg_no = WS_DF_MENUFORECOLOR;
  _bg_no = WS_DF_MENUBACKCOLOR;
  _ts_no = WS_DF_MENUTOPSHADOWCOLOR;
  _bs_no = WS_DF_MENUBOTTOMSHADOWCOLOR;

  WSMFpropertyCreateStart
  
    WSMFpropertyCreate( WSNmenuItems, char*,   _menu_str,WSSmenuItems);
    WSMFpropertyCreate( WSNmenuItemHeight, WSCushort, _item_height,WSSmenuItemHeight);
    WSMFpropertyCreate( WSNfont,    WSCuchar,    _font,WSSfont  );

    WSMFpropertyDelete(WSNtitleBar);

    WSMFpropertyValueChangeDef(WSCpopupFrame,WSNforeColor,short);
    WSMFpropertyValueChangeDef(WSCpopupFrame,WSNbackColor,short);
    WSMFpropertyValueChangeDef(WSCpopupFrame,WSNtopShadowColor,short);
    WSMFpropertyValueChangeDef(WSCpopupFrame,WSNbottomShadowColor,short);
    WSMFpropertyVisibleOff( WSNindicatorOn );
    WSMFpropertyVisibleOff( WSNmargin );
    WSMFpropertyVisibleOff( WSNmarginLeft );
    WSMFpropertyVisibleOff( WSNbarThickness );
    WSMFpropertyVisibleOff( WSNemboss );

  WSMFpropertyCreateEnd
}

WSMFproperty( WSCpopupFrame, WSNmenuItems,      char*,          _menu_str,WSGFstrdup("")); 
WSMFproperty( WSCpopupFrame, WSNmenuItemHeight, WSCushort, _item_height,30); 
WSMFproperty( WSCpopupFrame, WSNfont,    WSCuchar, _font, (char)WSGIappFontSet()->getDefaultFontNo()); 

void WSCpopupFrame::setWorkWSNmenuItems(char* ){
  if (_status_array != NULL){
    delete _status_array;
    _status_array = NULL;
  }
  setItemSensitive(0,True);
}

void WSCpopupFrame::getWorkWSNmenuItems(char** ){}
void WSCpopupFrame::setWorkWSNmenuItemHeight(WSCushort ){}
void WSCpopupFrame::getWorkWSNmenuItemHeight(WSCushort* ){}
void WSCpopupFrame::setWorkWSNfont(WSCuchar){}
void WSCpopupFrame::getWorkWSNfont(WSCuchar* ){}
void WSCpopupFrame::onResize(WSCrect*){}

long WSCpopupFrame::initialize(){
  WSCwindow::initialize();
  setPropertyV(WSNpixmapStyle, (WSCuchar)WS_DYNAMIC_PIXMAP);
  return WS_NO_ERR;
}
WSCpopupFrame::~WSCpopupFrame(){
  if (_status_array != NULL) {
    delete _status_array;
    _status_array = NULL;
  }
  delete _menu_str;
}

long WSCpopupFrame::_device_initialize(){
  WSCwindow::_device_initialize();
  WSCbool val = True;
  if (_dev != NULL){
    _dev->setValue(WSDEV_NO_FRAME,(void*)&val);
    _dev->setValue(WSDEV_FLOAT_ON_TOP,(void*)&val);
  }
  return WS_NO_ERR;
}

long WSCpopupFrame::draw(){
  if (_status_array == NULL) {
    setItemSensitive(0,True);
  }

  if (getVisible() == False){
    return WS_NO_ERR;
  }

  short px, py;
  WSGIappMouse()->getMousePosition(&px, &py);

  WSDdev* dev = getowndev();
  if (dev == NULL){
    return WS_ERR;
  }

  WSCbool absolute = getAbsoluteDraw(); 
  if (absolute == False && dev->isExposed(0, 0, _w, _h) == False){
    return WS_NO_ERR;
  }

  WSCushort st = _shadow_thick;
  long err = dev->beginDraw(0, 0, _w, _h, absolute);
  if (err != WS_NO_ERR){
    return WS_NO_ERR;
  }

  WSCbase::update();
  setAbsoluteDraw(False);

  dev->setForeColor(_bg_no);
  dev->drawFillRect(0, 0, _w, _h);

  WSGFdrawShadow(dev, _shadow_type, st, _fg_no,_ts_no,_bs_no,_bg_no, 0, 0, _w, _h);

  WSCstring str(_menu_str);  
  str.replaceString(",", "\n", 0);

  _value_effective = False;

  short posy = st;
  long i;
  long num = str.getWords("\n");    
  for(i=0; i < num; i++){
    WSCstring sect = str.getWord(i, "\n");
    sect.replaceString(":", "\n", 0);
    WSCstring sect_str = sect.getWord(0, "\n");

    if (_status_array[i] == False) {
      if (_emboss != False){
        dev->setForeColor(_ts_no);
        dev->drawString(st*2+3, posy +st+1, _w -st*4 -2, _item_height -st*2,
                 &sect_str, _font, WS_LEFT, -1, False);
      }else{
        dev->setHatchPattern(8);
      }
    }else{
      dev->setHatchPattern(0);
    }
    if (_x < px && px < _x +_w && _y + posy < py &&
         py < _y + posy + _item_height){
      if (_status_array[i] != False) {
        if (WSGIappDev()->getGuiPolicy() & WS_POLICY_WINDOWS){
          dev->setForeColor(WSGIappColorSet()->getDefaultColorNo(WS_DF_MENUSELECTCOLOR));
          dev->drawFillRect( st+1,posy +1,_w -st*2 -2,_item_height-2);
        }
      }
    }
    if (_emboss != False && _status_array[i] == False){
      dev->setForeColor(_bs_no);
    }else{
      dev->setForeColor(_fg_no);
    }
    if (_x < px && px < _x +_w && _y + posy < py &&
         py < _y + posy + _item_height){
      if (_status_array[i] != False) {
        if (WSGIappDev()->getGuiPolicy() & WS_POLICY_WINDOWS){
          dev->setForeColor(WSGIappColorSet()->getDefaultColorNo(WS_DF_MENUSELECTFORECOLOR));
        }
      }
    }
    dev->drawString(st*2+2, posy +st, _w -st*4 -2, _item_height -st*2,
          &sect_str, _font, WS_LEFT, -1, False);
    if (_x < px && px < _x +_w && _y + posy < py &&
         py < _y + posy + _item_height){
      if (_status_array[i] != False) {
        if (WSGIappDev()->getGuiPolicy() & WS_POLICY_ORIGINAL){
          WSGFdrawBtnShadow(dev, _shadow_type, st, _fg_no,
                _ts_no, _bs_no,_bg_no, st, posy, _w-st*2, _item_height);
        }
      }
      _value = 0; 
      WSCstring sect_value = sect.getWord(1, "\n");
      _value = atoi(sect_value.getString());
      _value_effective = True;
    }else{
      WSGFdrawShadow(dev, _shadow_type, st,
         _bg_no, _bg_no, _bg_no,_bg_no,st, posy, _w-st*2, _item_height,True);
    }
    posy += _item_height;
  }
  dev->endDraw();

  return WS_NO_ERR;

}

WSCbool WSCpopupFrame::getValue(long* val){
  *val = _value;
  return _value_effective;
}

void WSCpopupFrame::onVisibleChange(WSCbool fl){
  if (fl != False){
    WSDdev* dev = getowndev();
    if (dev == NULL){
      dev = attachdev();
      if (dev != NULL){
        char title_bar = WS_NO_TITLE;
        dev->setValue(WSDEV_TITLE_BAR, (void*)&title_bar);
        dev->setEnableEventBit(_event_mask);
      }
    }
    _parent_vis = True;

    if (dev != NULL){
      dev->setVisible(True);
    }
  }else{
    WSCbase::onVisibleChange(fl);
  }
}

long WSCpopupFrame::setItemSensitive(short no, WSCbool flag) {
  long ret = WS_ERR;

  WSCstring str(_menu_str);
  str.replaceString(",", "\n", 0);
  long num = str.getWords("\n");

  if (_status_array == NULL) {
    _status_array = new WSCbool[num];
    for (short i=0; i<num; i++) {
      _status_array[i] = True;
    }
  }

  if (no < num) {
    _status_array[no] = flag;
    ret = WS_NO_ERR;
  }

  return (ret);
}
void WSCpopupFrame::setEmboss(WSCbool fl){
  _emboss = fl;
}
WSCbool WSCpopupFrame::getEmboss(){
  return _emboss;
}
