//
// Copyright (C) 1999-2002 Toshikaz Hirabayashi
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// TOSHIKAZ HIRABAYASHI BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
// WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF
// OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
// Except as contained in this notice, the name of Toshikaz Hirabayashi shall
// not be used in advertising or otherwise to promote the sale, use or other
// dealings in this Software without prior written authorization from
// Toshikaz Hirabayashi.

#ifndef WSCSCRFORM_H
#define WSCSCRFORM_H

#include <WScom.h>
#include <WSCform.h>

class WSCscrFrame;
class WSCvscrBar;

#define WSCscrForm_VER  1001

class WSCscrForm   :public WSCform{

  protected:
    WSCscrFrame* _scr_area;
    WSCvscrBar*  _h_scr;
    WSCvscrBar*  _v_scr;
    WSCushort    _scr_area_w;
    WSCushort    _scr_area_h;

    WSCushort _v_scr_slider_sz;
    WSCushort _h_scr_slider_sz;
    WSCushort _v_scr_max_sz;
    WSCushort _h_scr_max_sz;

    short     _v_scr_x_bk;
    short     _h_scr_y_bk;
    WSCushort _v_scr_w_bk;
    WSCushort _v_scr_h_bk;
    WSCushort _h_scr_w_bk;
    WSCushort _h_scr_h_bk;

    WSCushort _work_width;
    WSCushort _work_height;
    WSCushort _wx_pos;
    WSCushort _wy_pos;
    WSCushort _increment;
    WSCushort _page_increment;
    WSCushort _scroll_width;
    WSCushort _scroll_height;
    WSCushort _bar_thick;
    short     _bar_back_color;
    short     _work_back_color;
    short     _scr_offset_x;
    short     _scr_offset_y;
    unsigned  _marginw:3;
    unsigned  _padding:5;
    unsigned  _hbar_visible:1;
    unsigned  _vbar_visible:1;
    unsigned  _virtual_scr:1;
    unsigned  _frame:1;
    unsigned  _no_scroll:1;

    static short _btn_x;
    static short _btn_y;
    static short _btn_x_pressed;
    static short _btn_y_pressed;
    static WSCushort _value_pressed;

    WSMFpropertyDef(WSNworkWidth,     WSCushort, _work_width  );
    WSMFpropertyDef(WSNworkHeight,    WSCushort, _work_height );
    WSMFpropertyDef(WSNhbarValue,     WSCushort, _wx_pos      );
    WSMFpropertyDef(WSNvbarValue,     WSCushort, _wy_pos      );
    WSMFpropertyDef(WSNincrement,     WSCushort, _increment   );
    WSMFpropertyDef(WSNpageIncrement, WSCushort, _page_increment );
    WSMFpropertyDef(WSNworkBackColor, short,     _work_back_color  );
    WSMFpropertyDef(WSNbarThickness,  WSCushort, _bar_thick   );
    WSMFpropertyDef(WSNbarShadowColor,short,     _bar_back_color   );
    WSMFpropertyDef(WSNhbarVisible,   WSCbool,   _hbar_visible);
    WSMFpropertyDef(WSNvbarVisible,   WSCbool,   _vbar_visible);
    WSMFpropertyDef(WSNscrollWidth,   WSCushort, _scroll_width );
    WSMFpropertyDef(WSNscrollHeight,  WSCushort, _scroll_height);
    WSMFpropertyDef(WSNmargin,  WSCuchar, _marginw);
    WSMFpropertyDef(WSNvirtualScroll, WSCbool, _virtual_scr);
    WSMFpropertyDef(WSNframe, WSCbool, _frame);

    virtual void setWorkWSNshadowThickness(WSCuchar);
    virtual void setWorkWSNforeColor(short);
    virtual void setWorkWSNtopShadowColor(short);
    virtual void setWorkWSNbottomShadowColor(short);
    virtual void setWorkWSNpixmapStyle(WSCuchar);
    virtual void setWorkWSNbackColor(short);
    virtual void setWorkWSNwidth(WSCushort);
    virtual void setWorkWSNheight(WSCushort);

    static void _h_scr_work_op(WSCbase*);
    static void _ha_scr_work_op(WSCbase*);
    static void _v_scr_work_op(WSCbase*);
    static void _va_scr_work_op(WSCbase*);
    static void _scr_mouse_press(WSCbase*);
    static void _scr_mouse_release(WSCbase*);
    static void _scr_mouse_move(WSCbase*);

    WSCushort _get_shift_width();
    WSCushort _get_shift_height();

    virtual void  _adjust();
    void _adjust_scr_area();
    void _adjust_children();
    void _redraw_scr();

    virtual long _device_initialize();
//    virtual WSCbool _use_bscrbar_class();
    WSCbool _get_hbar_visible();
    WSCbool _get_vbar_visible();
    void _set_no_scroll(WSCbool fl);
    virtual void _adjust_no_scroll();

  public:
    WSCscrForm(WSCbase*,char*);
    virtual ~WSCscrForm();

static void setUseScrBarClass(char*);
static char* getUseScrBarClass();

    virtual long initialize();
    virtual void update();

    virtual void onParentVisibleChange(WSCbool);
    virtual void onActivate();
    virtual void onChildAdded(WSCbase*);
    virtual void onValueChange();
    virtual void onGuiPolicyChange(long);
    virtual void onMousePress(WSCpoint*);
    virtual void onScrMousePress(WSCpoint*);
    virtual void onScrMouseRelease(WSCpoint*);
    virtual void onScrMouseMove(WSCpoint*);

    virtual long execEventProc(long ev,void*);
    virtual long clear();
    virtual long draw();
    virtual long redraw();
    virtual long cdraw();
    virtual long setPropertyEditMode(WSCbool );


    long getVisibleWidth();
    long getVisibleHeight();
    WSCbase* getScrFrame();
    WSMFguiClassDef(WSCscrForm,WSCform);
    WSMFversionDef(WSCscrForm);
};
#endif
