/*
 * Decompiled with CFR 0.152.
 */
package org.itscool.weber.user;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.itscool.commons.bean.BeanFactory;
import org.itscool.commons.bean.BeanUtil;
import org.itscool.commons.dao.BaseDao;
import org.itscool.commons.logging.AbstractLog;
import org.itscool.commons.logging.SimpleLog;
import org.itscool.commons.util.AngouUtil;
import org.itscool.commons.util.StringUtil;
import org.itscool.weber.user.Role;
import org.itscool.weber.user.RoleDao;
import org.itscool.weber.user.User;
import org.itscool.weber.user.UserDao;
import org.itscool.weber.user.UserManager;

public class UserEntityManager
implements UserManager {
    private AbstractLog log;
    private boolean initFlg = false;
    private static UserEntityManager instance = null;

    public static UserEntityManager getInstance() {
        if (instance == null) {
            instance = new UserEntityManager();
        }
        return instance;
    }

    private UserEntityManager() {
        BeanFactory factory = BeanFactory.getInstance();
        try {
            this.log = (AbstractLog)factory.getInstance("Log");
            if (!this.log.isInit()) {
                this.log = (AbstractLog)factory.createInstance("Log");
            }
            this.initFlg = true;
        }
        catch (Exception ioe) {
            this.log = SimpleLog.getInstance();
            this.log.info(ioe.getMessage());
        }
    }

    public boolean isInit() {
        return this.initFlg;
    }

    public void init() {
    }

    public boolean isUserCheck(HashMap roles, User user) {
        if (user == null) {
            return false;
        }
        if (roles == null || roles.size() == 0) {
            return this.isRoles(user);
        }
        return this.isRoles(roles, user);
    }

    private boolean isRoles(HashMap roles, User user) {
        boolean ret = false;
        Set keySet = roles.keySet();
        Iterator it = keySet.iterator();
        UserDao dao = new UserDao();
        while (it.hasNext()) {
            String userName;
            String key = (String)it.next();
            String roleName = (String)roles.get(key);
            User dbUser = dao.getUser(roleName, userName = user.getName());
            ret = this.isRole(user, dbUser);
            if (!ret) continue;
            user.setRole(dbUser.getRole());
            return ret;
        }
        return ret;
    }

    private boolean isRoles(User user) {
        boolean ret = false;
        UserDao dao = new UserDao();
        List users = dao.getUsers(user.getName());
        for (int i = 0; i < users.size(); ++i) {
            User dbUser = (User)users.get(i);
            ret = this.isRole(user, dbUser);
            if (!ret) continue;
            Role userRole = dbUser.getRole();
            user.setRole(userRole);
            return ret;
        }
        return ret;
    }

    private boolean isRole(User loginUser, User dbUser) {
        if (dbUser == null) {
            return false;
        }
        if (loginUser == null) {
            return false;
        }
        if (!dbUser.getName().equals(loginUser.getName())) {
            return false;
        }
        String pwd = "";
        try {
            byte[] pwdBytes = StringUtil.decodeHex((String)dbUser.getPwd(), (String)"ISO-8859-1");
            if (pwdBytes != null) {
                pwd = AngouUtil.decrypt((String)dbUser.getName(), (byte[])pwdBytes);
            } else {
                this.log.warn("passward decode hex is missing. user[" + dbUser.getName() + "] is non decode hex.");
                pwd = dbUser.getPwd();
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe.getMessage());
        }
        if (pwd == null) {
            return loginUser.getPwd() == null || loginUser.getPwd().length() == 0;
        }
        if (!pwd.equals(loginUser.getPwd())) {
            return false;
        }
        loginUser.setId(dbUser.getId());
        return true;
    }

    public void reload() {
    }

    public List getAllData() {
        UserDao userDao = new UserDao();
        List users = userDao.getAllData();
        for (int i = 0; i < users.size(); ++i) {
            User user = (User)users.get(i);
            if (user == null) continue;
            String pwd = "";
            try {
                byte[] pwdBytes = StringUtil.decodeHex((String)user.getPwd(), (String)"ISO-8859-1");
                pwd = AngouUtil.decrypt((String)user.getName(), (byte[])pwdBytes);
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe.getMessage());
            }
            user.setPwd(pwd);
        }
        return users;
    }

    public User getUser(String roleName, String userName) {
        RoleDao dao = new RoleDao();
        Role role = dao.getRole(roleName);
        if (role != null) {
            UserDao userDao = new UserDao();
            User user = userDao.getUser(role, userName);
            if (user != null) {
                try {
                    String pwd = UserEntityManager.decrypt(user.getName(), user.getPwd());
                    user.setPwd(pwd);
                }
                catch (IOException ioe) {
                    this.log.warn("passward decode hex is missing. user[" + user.getName() + "] is non decode hex.");
                }
            }
            return user;
        }
        return null;
    }

    public static String decrypt(String userName, String srcPwd) throws IOException {
        byte[] pwdBytes = StringUtil.decodeHex((String)srcPwd, (String)"ISO-8859-1");
        String dstPwd = AngouUtil.decrypt((String)userName, (byte[])pwdBytes);
        return dstPwd;
    }

    public static String encrypt(String userName, String srcPwd) throws IOException {
        byte[] pwdAngou = AngouUtil.encrypt((String)userName, (String)srcPwd);
        String pwdAngouStr = StringUtil.encodeHex((byte[])pwdAngou, (String)"ISO-8859-1");
        return pwdAngouStr;
    }

    public HashMap getUsers(String roleName) {
        HashMap<String, User> users = new HashMap<String, User>();
        RoleDao roleDao = new RoleDao();
        Role role = roleDao.getRole(roleName);
        UserDao dao = new UserDao();
        List lst = dao.getUsers(role);
        for (int i = 0; i < lst.size(); ++i) {
            User user = (User)lst.get(i);
            try {
                String pwd = UserEntityManager.decrypt(user.getName(), user.getPwd());
                user.setPwd(pwd);
            }
            catch (IOException ioe) {
                this.log.warn("passward decode hex is missing. user[" + user.getName() + "] is non decode hex.");
            }
            users.put(user.getName(), user);
        }
        return users;
    }

    public void delete(User user) throws IOException {
        UserDao dao = new UserDao();
        dao.delete(user);
    }

    public void delete(String roleName, User user) throws IOException {
        UserDao dao = new UserDao();
        if (user.getRoleId() == -1) {
            RoleDao roleDao = new RoleDao();
            Role role = roleDao.getRole(roleName);
            user.setRoleId(role.getId());
        }
        dao.delete(user);
    }

    public void delete(String roleName, String name) throws IOException {
        User user = new User();
        user.setName(name);
        this.delete(roleName, user);
    }

    public boolean add(User user) throws IOException {
        UserDao dao = new UserDao();
        User newUser = (User)BeanUtil.copyInstance((Object)user, (String)User.class.getName());
        String pwdAngouStr = UserEntityManager.encrypt(user.getName(), user.getPwd());
        newUser.setPwd(pwdAngouStr);
        int id = dao.save(newUser);
        user.setId(id);
        return true;
    }

    public boolean add(String roleName, User user) throws IOException {
        BaseDao dao;
        if (user.getRoleId() == -1) {
            dao = new RoleDao();
            Role role = dao.getRole(roleName);
            if (role == null) {
                return false;
            }
            user.setRoleId(role.getId());
        }
        dao = new UserDao();
        if (this.getUser(roleName, user.getName()) == null) {
            User newUser = (User)BeanUtil.copyInstance((Object)user, (String)User.class.getName());
            String pwdAngouStr = UserEntityManager.encrypt(user.getName(), user.getPwd());
            newUser.setPwd(pwdAngouStr);
            int id = dao.save(newUser);
            user.setId(id);
            return true;
        }
        return false;
    }

    public boolean add(String roleName, String name, String pwd) throws IOException {
        User user = new User();
        user.setName(name);
        user.setPwd(pwd);
        return this.add(roleName, user);
    }

    public void update(User user) throws IOException {
        UserDao dao = new UserDao();
        User newUser = (User)BeanUtil.copyInstance((Object)user, (String)User.class.getName());
        String pwdAngouStr = UserEntityManager.encrypt(user.getName(), user.getPwd());
        newUser.setPwd(pwdAngouStr);
        dao.update(newUser);
    }

    public void update(String roleName, User user) throws IOException {
        RoleDao roleDao = new RoleDao();
        Role role = roleDao.getRole(roleName);
        user.setId(role.getId());
        UserDao dao = new UserDao();
        User newUser = (User)BeanUtil.copyInstance((Object)user, (String)User.class.getName());
        String pwdAngouStr = UserEntityManager.encrypt(user.getName(), user.getPwd());
        newUser.setPwd(pwdAngouStr);
        dao.update(newUser);
    }

    public boolean addRole(Role role) {
        RoleDao roleDao = new RoleDao();
        if (roleDao.getRole(role.getName()) != null) {
            return false;
        }
        roleDao.save(role);
        return true;
    }

    public boolean deleteRole(Role role) {
        RoleDao roleDao = new RoleDao();
        UserDao userDao = new UserDao();
        if (userDao.getUsers(role).size() > 0) {
            return false;
        }
        roleDao.delete(role);
        return true;
    }
}

