/*
 * Decompiled with CFR 0.152.
 */
package org.itscool.weber.testcase;

import java.net.URL;
import junit.framework.TestCase;
import org.itscool.commons.bean.BeanFactory;
import org.itscool.commons.connection.ConnectionManager;
import org.itscool.commons.logging.AbstractLog;
import org.itscool.commons.logging.SimpleLog;
import org.itscool.weber.action.Action;
import org.itscool.weber.testcase.MockActionBucket;
import org.itscool.weber.testcase.MockGeneralForm;
import org.itscool.weber.user.RoleException;
import org.itscool.weber.user.User;

public abstract class WeberTestCase
extends TestCase {
    protected BeanFactory factory = BeanFactory.getInstance();
    protected MockActionBucket bucket = new MockActionBucket();
    protected MockGeneralForm request = new MockGeneralForm();
    protected static AbstractLog log = SimpleLog.getInstance();

    public WeberTestCase() {
        ClassLoader parent = Thread.currentThread().getContextClassLoader();
        URL diconfigUrl = parent.getResource("di-config.xml");
        if (diconfigUrl == null) {
            String err = "di-config.xml path is null.";
            WeberTestCase.fail((String)err);
            log.error(err);
            return;
        }
        String configFwName = diconfigUrl.getPath();
        BeanFactory factory = BeanFactory.getInstance();
        try {
            if (!log.isInit()) {
                log = (AbstractLog)factory.createInstance("Log");
            }
        }
        catch (Exception ioe) {
            // empty catch block
        }
        try {
            factory.create(configFwName);
            ConnectionManager mgr = (ConnectionManager)factory.createInstance("ConnectionManager");
            mgr.init();
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public void assertDoExecute(Action action, Object form, String forward) throws Exception {
        String result = "";
        this.bucket.setForm(form);
        action.init(this.bucket, this.request);
        result = action.doExecute(this.bucket);
        WeberTestCase.assertEquals((String)"doExcecute", (String)forward, (String)result);
    }

    public void assertCheckUserRole(Action action, User user, boolean ret) {
        try {
            this.bucket.setAttributeFromSession("org_itscool_weber_action_USER", user);
            action.init(this.bucket, this.request);
            action.beforeCheckRole();
            boolean isUser = action.checkRole(this.bucket);
            WeberTestCase.assertEquals((String)"checkUserRole", (boolean)ret, (boolean)isUser);
        }
        catch (RoleException re) {
            WeberTestCase.assertEquals((String)"checkUserRole", (boolean)ret, (boolean)false);
        }
    }

    public void assertValidate(Action action, String forward) throws Exception {
        action.setGeneralForm(this.request);
        String ret = action.validate(this.bucket);
        WeberTestCase.assertEquals((String)"validate", (String)forward, (String)ret);
    }
}

