/*
 * Decompiled with CFR 0.152.
 */
package org.itscool.stylist.io;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.LinkedList;
import java.util.StringTokenizer;
import org.itscool.commons.document.XmlConfigReader;
import org.itscool.commons.util.FileUtil;
import org.itscool.stylist.tag.HtmlAttribute;
import org.itscool.stylist.tag.HtmlRootTag;
import org.itscool.stylist.tag.HtmlTag;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class HtmlConfigReader
extends XmlConfigReader {
    public static final String LINE = System.getProperty("line.separator");
    private String defaultEncode;

    public void create(String uri, byte[] buf, LinkedList nodeList) throws IOException {
        String bufStr = new String(buf);
        int xmlStartPos = bufStr.indexOf("<?xml");
        int xmlEndPos = bufStr.indexOf("?>");
        int dtdStartPos = bufStr.indexOf("<!DOCTYPE");
        int dtdEndPos = bufStr.indexOf("dtd\">");
        String xml = null;
        String dtd = null;
        String xhtml = null;
        if (xmlStartPos < 0) {
            return;
        }
        xml = bufStr.substring(0, xmlEndPos + 2);
        if (dtdEndPos > 0) {
            dtd = bufStr.substring(dtdStartPos, dtdEndPos + 5);
            xhtml = bufStr.substring(dtdEndPos + 5, bufStr.length());
        } else if (xmlStartPos >= 0) {
            xhtml = bufStr.substring(xmlEndPos + 2, bufStr.length());
        }
        String cnvStr = xml != null ? xml + xhtml : (dtdEndPos > 0 ? xhtml : bufStr);
        if (!(nodeList instanceof HtmlRootTag)) {
            throw new ClassCastException("filed cast HtmlRootTag => " + nodeList.getClass().getName());
        }
        HtmlRootTag top = (HtmlRootTag)nodeList;
        top.setXml(xml);
        top.setDtd(dtd);
        super.create(uri, cnvStr.getBytes(), nodeList);
    }

    public void create(String path, LinkedList nodeList) throws IOException {
        String line;
        if (!(nodeList instanceof HtmlRootTag)) {
            throw new ClassCastException("filed cast HtmlRootTag => " + nodeList.getClass().getName());
        }
        HtmlRootTag top = (HtmlRootTag)nodeList;
        long lastModified = FileUtil.getLastModified((String)path);
        top.setLastModified(lastModified);
        String encode = top.getEncode();
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        InputStreamReader isr = new InputStreamReader((InputStream)new FileInputStream(path), encode);
        BufferedReader br = new BufferedReader(isr);
        boolean xmlSec = false;
        while ((line = br.readLine()) != null) {
            if (line.indexOf("<?xml") >= 0 && !xmlSec) {
                if (line.trim().lastIndexOf("?>") != -1) {
                    top.setXml(line);
                } else {
                    StringBuffer xml = new StringBuffer(line);
                    while ((line = br.readLine()) != null) {
                        xml.append(line);
                        if (line.trim().lastIndexOf("?>") == -1) continue;
                    }
                    top.setXml(xml.toString());
                }
                xmlSec = true;
            }
            if (!xmlSec) {
                String defaultXml = "<?xml version=\"1.0\" encoding=\"" + encode + "\" ?>";
                top.setXml(defaultXml);
                bout.write(defaultXml.getBytes());
                bout.write(LINE.getBytes());
                xmlSec = true;
            }
            if (line == null) continue;
            if (line.trim().indexOf("<!DOCTYPE") == 0) {
                if (line.trim().lastIndexOf(">") != -1) {
                    top.setDtd(line);
                    continue;
                }
                StringBuffer dtd = new StringBuffer(line);
                while ((line = br.readLine()) != null) {
                    dtd.append(line);
                    if (line.trim().lastIndexOf(">") == -1) continue;
                }
                top.setDtd(dtd.toString());
                continue;
            }
            bout.write(line.getBytes(encode));
            bout.write(LINE.getBytes());
        }
        super.create(path, bout.toByteArray(), nodeList);
        top = (HtmlRootTag)nodeList;
    }

    public String create(String path, String encode) throws IOException {
        String line;
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        InputStreamReader isr = new InputStreamReader((InputStream)new FileInputStream(path), encode);
        BufferedReader br = new BufferedReader(isr);
        StringBuffer sb = new StringBuffer();
        while ((line = br.readLine()) != null) {
            sb.append(line).append(LINE);
        }
        return sb.toString();
    }

    protected void doCreate(LinkedList dataList) throws IOException {
        Element root = this.document.getDocumentElement();
        if (root == null) {
            String err = "Can not root element at weber-message.xml(" + ((Object)((Object)this)).getClass().getName() + ")";
            throw new IOException(err);
        }
        HtmlRootTag tag = (HtmlRootTag)dataList;
        tag.setTagKind("tag");
        tag.setTagName(root.getTagName());
        NamedNodeMap attrs = root.getAttributes();
        this.addAttribute(tag, attrs);
        NodeList nodeList = root.getChildNodes();
        this.createTagTree(nodeList, tag);
    }

    protected void createTagTree(NodeList nodeList, HtmlTag parent) throws IOException {
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            NamedNodeMap attrs = node.getAttributes();
            NodeList childList = node.getChildNodes();
            int childSize = childList.getLength();
            String nodeValue = node.getNodeValue() != null && node.getNodeValue().length() > 0 ? node.getNodeValue().trim() : "";
            String nodeName = node.getNodeName();
            if (nodeName.equals("#text") && nodeValue.length() == 0) continue;
            HtmlTag childTag = nodeName.equals("#text") ? this.createHtmlTag("text", nodeValue, attrs) : (nodeName.equals("#comment") ? this.createHtmlTag("comment", nodeValue, attrs) : (childSize > 0 || nodeName.equals("textarea") ? this.createHtmlTag("tag", nodeName, attrs) : (nodeName.equals("#cdata-section") ? this.createHtmlTag("cdata", nodeValue, attrs) : this.createHtmlTag("simple", nodeName, attrs))));
            childTag.setParent(parent);
            parent.add(childTag);
            this.createTagTree(childList, childTag);
        }
    }

    protected HtmlTag createHtmlTag(String tagKind, String tagName, NamedNodeMap attrs) {
        HtmlTag tag = new HtmlTag();
        tag.setTagName(tagName);
        tag.setTagKind(tagKind);
        this.addAttribute(tag, attrs);
        return tag;
    }

    protected void addAttribute(HtmlTag node, NamedNodeMap attrs) {
        if (attrs == null) {
            return;
        }
        int size = attrs.getLength();
        for (int i = 0; i < size; ++i) {
            HtmlAttribute attr;
            Node attrNode = attrs.item(i);
            String attrName = attrNode.getNodeName();
            String attrValue = attrNode.getNodeValue();
            if (attrName.equals("title")) {
                this.parseControlAttribute(node, attrNode);
                attr = new HtmlAttribute();
                attr.setName(attrName);
                attr.setValue(attrValue);
                node.addAttribute(attr);
            } else {
                attr = new HtmlAttribute();
                attr.setName(attrName);
                attr.setValue(attrValue);
                node.addAttribute(attr);
            }
            if (attrName == null || !attrName.equals("w_kind")) continue;
            node.setTagKind(attrValue);
        }
    }

    public void parseControlAttribute(HtmlTag node, Node attrNode) {
        String attrName = attrNode.getNodeName();
        String properties = attrNode.getNodeValue();
        if (properties == null || properties.indexOf("w_kind") < 0) {
            return;
        }
        if (properties == null || properties.length() == 0) {
            return;
        }
        StringTokenizer dataSt = new StringTokenizer(properties, ":");
        while (dataSt.hasMoreTokens()) {
            String data = dataSt.nextToken().trim();
            StringTokenizer propertySt = new StringTokenizer(data, "=");
            String name = propertySt.nextToken();
            if (name == null) {
                throw new RuntimeException("name is null query=" + properties);
            }
            name = name.trim();
            String property = null;
            if (propertySt.hasMoreTokens()) {
                property = propertySt.nextToken();
            }
            HtmlAttribute attr = new HtmlAttribute();
            attr.setName(name);
            attr.setValue(property);
            node.addAttribute(attr);
            if (name == null || property == null || !name.equals("w_kind")) continue;
            node.setTagKind(property);
        }
    }

    public String getDefaultEncode() {
        return this.defaultEncode;
    }

    public void setDefaultEncode(String defaultEncode) {
        this.defaultEncode = defaultEncode;
    }
}

