/*
 * Decompiled with CFR 0.152.
 */
package org.itscool.commons.util;

import java.util.List;
import org.itscool.commons.util.TagInfo;

public class TagUtil {
    public static final String SCOPE_PAGE = "page";
    public static final String SCOPE_REQUEST = "request";
    public static final String SCOPE_SESSION = "session";
    public static final String SCOPE_APPLICATION = "application";

    public static boolean isCheckedValue(Object beanVal, String value) {
        boolean ret = false;
        if (beanVal == null || value == null || value.length() == 0) {
            return ret;
        }
        if (beanVal instanceof List) {
            List al = (List)beanVal;
            for (int i = 0; i < al.size(); ++i) {
                Object bv = al.get(i);
                boolean b = TagUtil.isCheckedValue(bv, value);
                if (!b) continue;
                ret = true;
                break;
            }
        } else if (beanVal instanceof Boolean) {
            Boolean chkVal = new Boolean(value);
            if (beanVal != null && beanVal.toString().equals(chkVal.toString())) {
                ret = true;
            }
        } else if (beanVal instanceof String) {
            String chkVal = new String(value);
            if (beanVal != null && beanVal.toString().equals(chkVal.toString())) {
                ret = true;
            }
        } else if (beanVal instanceof Integer) {
            Integer chkVal = new Integer(value);
            if (beanVal != null && beanVal.toString().equals(chkVal.toString())) {
                ret = true;
            }
        } else if (beanVal instanceof Double) {
            Double chkVal = new Double(value);
            if (beanVal != null && beanVal.toString().equals(chkVal.toString())) {
                ret = true;
            }
        } else if (beanVal instanceof Float) {
            Float chkVal = new Float(value);
            if (beanVal != null && beanVal.toString().equals(chkVal.toString())) {
                ret = true;
            }
        } else if (beanVal instanceof Long) {
            Long chkVal = new Long(value);
            if (beanVal != null && beanVal.toString().equals(chkVal.toString())) {
                ret = true;
            }
        } else {
            String chkVal = new String(value);
            if (beanVal != null && beanVal.toString().equals(chkVal.toString())) {
                ret = true;
            }
        }
        return ret;
    }

    public static TagInfo createTagInfo(String html, String tag) {
        int startIndex = html.indexOf("<" + tag);
        int endIndex = html.indexOf("</" + tag + ">");
        if (startIndex == -1 || endIndex == -1) {
            return null;
        }
        String body = html.substring(startIndex, endIndex + ("</" + tag + ">").length());
        int startBodyIndex = body.indexOf(">") + 1;
        int endBodyIndex = body.indexOf("</" + tag + ">");
        if (endBodyIndex == -1) {
            return null;
        }
        String bodyIn = body.substring(startBodyIndex, endBodyIndex);
        TagInfo tagInfo = new TagInfo();
        tagInfo.setDataInTag(bodyIn);
        tagInfo.setStartTag(body.substring(0, startBodyIndex));
        tagInfo.setEndTag(body.substring(endBodyIndex, body.length()));
        return tagInfo;
    }
}

