/*
 * Decompiled with CFR 0.152.
 */
package org.itscool.commons.util;

import java.util.Calendar;
import org.itscool.commons.util.DateElement;
import org.itscool.commons.util.DateFormatUtil;
import org.itscool.commons.util.MonthTable;

public class MonthTableMain {
    public static void toDisplay(MonthTable month) {
        StringBuffer sb = new StringBuffer();
        DateElement day = month.getDay(month.getYear(), month.getMonth(), 1);
        String sp = "|";
        String line = System.getProperty("line.separator");
        sb.append(month.getYear()).append("/");
        sb.append(month.getMonth()).append(line);
        sb.append("---+---+---+---+---+---+---+");
        sb.append(line);
        sb.append("sun|mon|tue|wen|thr|fri|sat|");
        sb.append(line);
        sb.append("---+---+---+---+---+---+---+");
        sb.append(line);
        int firstYobi = day.getYobi();
        if (firstYobi != 1) {
            Calendar cal = DateFormatUtil.getLastMonthWeek(month.getYear(), month.getMonth());
            for (int i = 1; i < firstYobi; ++i) {
                day = month.getDay(cal);
                if (day.getDay() < 10) {
                    sb.append(" ");
                }
                sb.append(day.getDay());
                sb.append("-").append(sp);
                cal.add(5, 1);
            }
        }
        for (int i = 0; i < month.getMaxday(); ++i) {
            day = month.getDay(month.getYear(), month.getMonth(), i + 1);
            if (day.getDay() < 10) {
                sb.append(" ");
            }
            sb.append(day.getDay());
            if (day.isHoliday()) {
                sb.append("*").append(sp);
            } else {
                sb.append(" ").append(sp);
            }
            if (day.getYobi() != 7) continue;
            sb.append(line);
        }
        DateElement lastDay = month.getDay(month.getYear(), month.getMonth(), month.getMaxday());
        if (lastDay.getYobi() != 7) {
            Calendar cal = Calendar.getInstance();
            cal.set(1, month.getYear());
            cal.set(2, month.getMonth() - 1);
            cal.set(5, month.getMaxday());
            for (int i = lastDay.getYobi(); i < 7; ++i) {
                day = month.getDay(cal);
                if (day.getDay() < 10) {
                    sb.append(" ");
                }
                sb.append(day.getDay());
                sb.append("+").append(sp);
                cal.add(5, 1);
            }
            sb.append(line);
        }
        sb.append("---+---+---+---+---+---+---+");
        sb.append(line);
        System.out.println(sb.toString());
    }

    public static void main(String[] argv) {
        for (int i = 0; i < 12; ++i) {
            MonthTable month = new MonthTable(2005, i + 1);
            MonthTableMain.toDisplay(month);
        }
    }
}

