/*
 * Decompiled with CFR 0.152.
 */
package org.itscool.commons.pool;

import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import org.itscool.commons.pool.ObjectPoolElement;
import org.itscool.commons.pool.ObjectPoolEventListener;
import org.itscool.commons.pool.ObjectPoolRuntimeException;

public class ObjectPool {
    private ObjectPoolEventListener listener = null;
    private Vector pool = new Vector();
    private int initSize;
    private int maxSize;

    public ObjectPool(ObjectPoolEventListener listener, int initSize, int maxSize) {
        this.listener = listener;
        this.initSize = initSize;
        this.maxSize = maxSize;
        if (maxSize < initSize) {
            throw new ObjectPoolRuntimeException("pool size is warning(maxSize < initSize).");
        }
    }

    public int getPoolSize() {
        return this.pool.size();
    }

    public int getInitSize() {
        return this.initSize;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[INIT SIZE]").append(this.initSize).append(", ");
        sb.append("[POOL SIZE]").append(this.pool.size()).append(", ");
        sb.append("[MAX  SIZE]").append(this.maxSize).append(", ");
        return sb.toString();
    }

    public synchronized ObjectPoolElement addNewElement(Object obj) {
        if (this.pool.size() >= this.maxSize) {
            throw new ObjectPoolRuntimeException("pool size is MAX");
        }
        ObjectPoolElement element = new ObjectPoolElement();
        element.setObject(obj);
        element.setUse(false);
        this.pool.addElement(element);
        this.notifyAll();
        return element;
    }

    public synchronized void returnElement(Object obj) {
        for (int i = 0; i < this.pool.size(); ++i) {
            ObjectPoolElement elem = (ObjectPoolElement)this.pool.get(i);
            if (elem.getObject() != obj) continue;
            elem.setUse(false);
        }
        this.notifyAll();
    }

    public synchronized Object getElement() {
        Object obj = null;
        for (int i = 0; i < this.pool.size(); ++i) {
            ObjectPoolElement elem = (ObjectPoolElement)this.pool.get(i);
            if (elem.isUse()) continue;
            elem.setUse(true);
            return elem.getObject();
        }
        if (this.pool.size() < this.maxSize && (obj = this.listener.doMissingElementEvent()) != null) {
            ObjectPoolElement elem = this.addNewElement(obj);
            elem.setUse(true);
            return elem.getObject();
        }
        throw new ObjectPoolRuntimeException("pool is no buffer.");
    }

    public synchronized Object getElement(int timeout) {
        long startTime = new Date().getTime();
        Object obj = null;
        while ((obj = this.getElement()) == null) {
            try {
                this.wait(timeout);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            if (new Date().getTime() - startTime < (long)timeout) continue;
            throw new ObjectPoolRuntimeException("pool is no buffer.");
        }
        return obj;
    }

    public synchronized void release() {
        Enumeration element = this.pool.elements();
        while (element.hasMoreElements()) {
            ObjectPoolElement elem = (ObjectPoolElement)element.nextElement();
            this.listener.doReleaseElementEvent(elem.getObject());
        }
        this.pool.removeAllElements();
    }
}

