<?php
/*
 *
 *
 *    Weasy (admin.php)
 *    Mafice <mafice@mflabo.net>
 *
 *
 */


require_once 'config.php';


  session_start();
  session_regenerate_id();


  //ログインしているかチェック
  if(!isset($_SESSION['password']) || ($_SESSION['password'] !== $PASSWORD)){

    print "<a href='login'>Login</a>";
    exit(1);
  }




  if(isset($_POST['mode'])){



    //CSRF対策
    if(!isset($_SESSION['uid']) || ($_SESSION['uid'] !== $_POST['uid'])){

      print "<a href='login'>Login</a>";
      exit(1);
    }



    switch($_POST['mode']){

      case 'new':

        $db      = file(ENTRY_DB_PATH);
        $db[]    = time().uniqid().",".htmlspecialchars($_POST['title']).
                                   ",".htmlspecialchars($_POST['tags']).
                                   ",".htmlspecialchars($_POST['body'])."\n";


        //保存
        file_put_contents(ENTRY_DB_PATH, $db);
        unset($db);
      break;

      //--------------------------------------------



      case 'edit':

        $db = file(ENTRY_DB_PATH);

        for($i=0; isset($db[$i]); $i++){

          if(strncmp($_POST['id'], $db[$i], strlen($_POST['id'])) == 0){

            $db[$i] = $_POST['id'].",".htmlspecialchars($_POST['title']).
                                   ",".htmlspecialchars($_POST['tags']).
                                   ",".htmlspecialchars($_POST['body'])."\n";
            break;
          }
        }

        //保存
        file_put_contents(ENTRY_DB_PATH, $db);
        unset($db);
      break;

      //--------------------------------------------



      case 'delete':

        $db = file(ENTRY_DB_PATH);

        for($i=0; isset($db[$i]); $i++){

          if(strncmp($_POST['id'], $db[$i], strlen($_POST['id'])) == 0){

            $db[$i] = '';
            break;
          }
        }

        //保存
        file_put_contents(ENTRY_DB_PATH, $db);
      break;

      //--------------------------------------------

    }
  }


?>
<!DOCTYPE html>
<html>
<head>

  <meta charset="utf-8">
  <title>admin | Weasy</title>

  <script>

    function openEditor(id){

      document.getElementById('form_title').value      = document.getElementById('entry_title_'+id).innerText;
      document.getElementById('form_tags').value       = document.getElementById('entry_tags_'+id).innerText;
      document.getElementById('form_body').value       = document.getElementById('entry_body_'+id).innerText;
      document.getElementById('form_id').value         = id;
      document.getElementById('editor').style.display  = 'block';
    }

  </script>


  <style>


    #entryList{
      width:            100%;
      marign:           10px;
      padding:          2px;
    }

    #entryList thead{
      background-color: #888;
      width:            100%;
      marign:           0;
      padding:          2px;
    }


    #entryList tbody{
      background-color: #ccc;
      width:            100%;
      marign:           0;
      padding:          2px;
    }


    #entryList tbody > tr:hover{
      background-color: #ddd;
    }

    .entry_title{
      width: 20%;
    }

    .entry_tags{
      width: 20%;
    }

    .entry_body{
      width: 50%;
    }

    .entry_tools{
      width: 10%;
    }

    table{
      border-collapse: collapse;
    }

    textarea{
      height:  120px;
      width:   70%;
    }


    #new_editor, #editor{
      padding:          20px;
      margin:           40px;
      display:          none;
      background-color: #ccc;
    }

  </style>

</head>
<body>

<button onClick="document.getElementById('new_editor').style.display='block';" style="float:right;">追加</button>
<br>

<div id	="new_editor">
  <h3>追加</h3>
  <form action="admin.php" method="POST">
    <table border="0">
     <tr><td>タイトル:</td><td><input type="text" name="title"></td></tr>
     <tr><td>タグ:</td><td><input type="text" name="tags"></td></tr>
    </table>

    <p>本文:</p>
    <textarea name="body"></textarea>
    <input type="hidden" name="mode" value="new">
    <input type="hidden" name="uid" value="<?php echo $_SESSION['uid']; ?>">
    <br><br>
    <input type="submit" value="送信">
  </form>
</div>



<div id="editor">
  <h3>編集</h3>
  <form action="admin.php" method="POST">
    <table border="0">
     <tr><td>タイトル:</td><td><input type="text" name="title" id="form_title"></td></tr>
     <tr><td>タグ:</td><td><input type="text" name="tags"  id="form_tags"></td></tr>
    </table>

    <p>本文:</p>
    <textarea name="body" id="form_body"></textarea>

    <input type="hidden" name="mode" value="edit">
    <input type="hidden" name="id" id="form_id" value="">
    <input type="hidden" name="uid" value="<?php echo $_SESSION['uid']; ?>">
    <br><br>
    <input type="submit" value="送信">
  </form>
</div>



<table id="entryList">
<thead>
  <td>タイトル</td>
  <td>タグ</td>
  <td>本文</td>
  <td></td>
</thead>

<tbody>

<?php

  //
  //  エントリをリストアップ
  //

  foreach(file(ENTRY_DB_PATH) as $line){

    $entry = str_getcsv($line);

    print <<< HDOC
      <tr>
        <td id="entry_title_{$entry[0]}" class="entry_title">{$entry[1]}</td>
        <td id="entry_tags_{$entry[0]}"  class="entry_tags">{$entry[2]}</td>
        <td id="entry_body_{$entry[0]}"  class="entry_body">{$entry[3]}</td>
        <td class="entry_tools">
          <button onClick="openEditor('{$entry[0]}')">編集</button>&nbsp;&nbsp;
          <form action="admin.php" method="POST">
            <input type="hidden" name="mode" value="delete">
            <input type="hidden" name="uid"  value="{$_SESSION['uid']}">
            <input type="hidden" name="id"   value="{$entry[0]}">
            <input type="submit" value="削除">
          </form>
        </td>
      </tr>
HDOC;
  }


?>

</tbody>
</table>

</body>
</html>

