// $Id: CTranslateTask.h,v 1.13 2003/05/10 06:46:45 ta_muto Exp $
// The class which helps XSLT processing.

#ifndef __wax_CTranslateTask_h
#define __wax_CTranslateTask_h

#include <common.h>
#include <collection.h>
#include <views/ITask.h>
#include <views/IXmlSource.h>
#include <views/IXslSource.h>

namespace wax {
	#define MAX_PARAMETERS	64

	class CTranslateTask : public ITask {
		IXmlSource* xmlSource;
		IXslSource* xslSource;
		CCollection params;
		char* paramsArray[MAX_PARAMETERS];
		
		xmlDocPtr result;
	public:
		CTranslateTask();
		~CTranslateTask();
		
		bool parse(CEnvironment* runenv, xmlNodePtr cur);
		bool execute();
		void output(IWriter* writer);
	private:
		IXmlSource* parseSourceTag(CEnvironment* runenv, xmlNodePtr cur, xmlNsPtr ns);
		IXslSource* parseStylesheetTag(CEnvironment* runenv, xmlNodePtr cur, xmlNsPtr ns);
		bool parseStylesheetParams(CEnvironment* runenv, xmlNodePtr cur, xmlNsPtr ns);
		void matchParameter(CEnvironment* runenv);
		const char** getXslParameter();
		
		void addParameter(const xmlChar* name, const xmlChar* value, bool fixed);
		void supportEnvironment();
		void addEnvironment(char* env);
	} ;
}

#endif
