#ifndef TCP_IP_DEVICE_H
#define TCP_IP_DEVICE_H

/*!
  \file
  \brief TCP/IP foCX

  \author Satofumi KAMIMURA

  $Id$
  
  \todo Windows(Cygwin, MBCS) ɂēmFs
  \todo SDL_net CXg[ĂȂꍇ̏
*/

#include "config.h"
#ifdef HAVE_LIBSDL_NET
#include <SDL_net.h>
#endif
#include "connectionDevice.h"
#include "ringBuffer_template.h"


/*!
  \brief connectionDevice.h  TCP/IP 
*/
class TcpipDevice : public ConnectionDevice {
#ifdef HAVE_LIBSDL_NET
  bool is_disconnected;
  TCPsocket tcp_socket;
  SDLNet_SocketSet socket_set;
  RingBuffer<unsigned char> *recv_buffer;
#endif

  void check(int timeout);
  
public:
  TcpipDevice(void);
#ifdef HAVE_LIBSDL_NET
  TcpipDevice(TCPsocket socket);
#endif
  ~TcpipDevice(void);
  int connect(const char *host, int port);
  void disconnect(void);
  bool is_connect(void);
  int setBaudrate(long baudrate);
  int recv(void *area, unsigned long maxlen, int timeout = 0);
  int send(const void *area, unsigned long len);
  int copy(void *area, unsigned long len);
  void flush(void);
  long size(void);
};

#endif /* !TCP_IP_DEVICE_H */
