#ifndef VXV_DIRECTION_H
#define VXV_DIRECTION_H

/*!
  \file
  \brief pxNX

  \author Satofumi KAMIMURA

  $Id$
*/

#include <math.h>
#include "math_util.h"
#include "dll_macro.h"


/*!
  \brief pxNX
*/
class DECLSPEC VXV_Direction {
  friend class RC_Coordinate;
  friend class RunCtrl;
  friend class URGCtrl2D;
  friend class URGCtrl3D;
  friend class RunSimulator;
  friend DECLSPEC VXV_Direction RCCALL deg(int degree);
  friend DECLSPEC VXV_Direction RCCALL rad(double radian);
  long div16;
  
  VXV_Direction(const VXV_Direction* rhs) : div16(rhs->div16) {}
  
public:
  VXV_Direction(void) : div16(0) {}
  ~VXV_Direction(void) {}

  /*!
    \brief ZqI[o[[h
  */
  VXV_Direction& VXV_Direction::operator+=(const VXV_Direction& rhs) {
    div16 += rhs.div16;
    return *this;
  }

  /*!
    \brief ZqI[o[[h
  */
  VXV_Direction& VXV_Direction::operator-=(const VXV_Direction& rhs) {
    div16 -= rhs.div16;
    return *this;
  }

  /*!
    \brief ZqI[o[[h
  */
  VXV_Direction operator+(const VXV_Direction& rhs) const {
    return VXV_Direction(this) += rhs;
  }

  /*!
    \brief ZqI[o[[h
  */
  VXV_Direction operator-(const VXV_Direction& rhs) const {
    return VXV_Direction(this) -= rhs;
  }
  
  /*!
    \brief degree Pʂ̌Ԃ
    \retval px [degree]
  */
  int deg(void) const {
    return (360 * div16 / 0x10000);
  }

  /*!
    \brief radian Pʂ̌Ԃ
    \retval px [radian]
  */
  double rad(void) const {
    return (2.0 * M_PI * div16 / 0x10000);
  }
};

#endif /* !VXV_DIRECTION_H */
