/*
  TCP/IP foCX
  Satofumi KAMIMURA
  $Id$
*/

#include "tcpipDevice.h"


/*!
  \brief IuWFNg̐

  ڑȃIuWFNg𐶐
*/
TcpipDevice::TcpipDevice(void)
#ifdef HAVE_LIBSDL_NET
  : is_disconnected(false), tcp_socket(NULL) 
#endif
{
#ifdef HAVE_LIBSDL_NET
  socket_set = SDLNet_AllocSocketSet(1);
#endif
}


#ifdef HAVE_LIBSDL_NET
TcpipDevice::TcpipDevice(TCPsocket socket) {
  tcp_socket = socket;
  socket_set = SDLNet_AllocSocketSet(1);
  SDLNet_TCP_AddSocket(socket_set, tcp_socket);
}
#endif


TcpipDevice::~TcpipDevice(void) {
  disconnect();
#ifdef HAVE_LIBSDL_NET
  SDLNet_FreeSocketSet(socket_set);
#endif
}


/*!
  \brief wzXgɐڑ

  \param host [i] zXg
  \param port [i] |[g

  \retval 0 I
  \retval ߂l < 0 G[
*/
int TcpipDevice::connect(const char *host, int port) {
#ifdef HAVE_LIBSDL_NET
  IPaddress ip;
  SDLNet_ResolveHost(&ip, host, port);
  tcp_socket = SDLNet_TCP_Open(&ip);
  if (!tcp_socket) {
    disconnect();
    return -1;
  }
  SDLNet_TCP_AddSocket(socket_set, tcp_socket);
  recv_buffer = new RingBuffer<unsigned char>(BUFSIZ);

  return 0;
#else
  return -1;
#endif
}


void TcpipDevice::disconnect(void) {
#ifdef HAVE_LIBSDL_NET
  is_disconnected = true;
  if (tcp_socket) {
    SDLNet_TCP_DelSocket(socket_set, tcp_socket);
    SDLNet_TCP_Close(tcp_socket);
    tcp_socket = NULL;
  }
#endif
}


/*!
  \brief {[[g̕ύX

  \param baudrate [i] {[[g
  \retval 0 I

  \attention serialDevice.h Ƃ̌݊̂߂ɑ݂BȂ
*/
int TcpipDevice::setBaudrate(long baudrate) {
  return 0;
}


bool TcpipDevice::is_connect(void) {
#ifdef HAVE_LIBSDL_NET
  return ((tcp_socket != NULL) && !is_disconnected) ? true : false;
#else
  return -1;
#endif
}


#ifdef HAVE_LIBSDL_NET
void TcpipDevice::check(int timeout) {
  if ((recv_buffer->size() > 0) ||
      (SDLNet_CheckSockets(socket_set, timeout) <= 0)) {
    return;
  }
  if (is_connect() && SDLNet_SocketReady(tcp_socket)) {
    int maxlen = recv_buffer->free_size();
    maxlen = (maxlen > BUFSIZ) ? BUFSIZ : maxlen;
    unsigned char buffer[BUFSIZ];
    int n = SDLNet_TCP_Recv(tcp_socket, buffer, maxlen);
    if (n <= 0) {
      is_disconnected = true;
      return;
    }
    recv_buffer->put(buffer, n);
  }
}
#endif


int TcpipDevice::recv(void *area, unsigned long maxlen, int timeout) {
#ifdef HAVE_LIBSDL_NET
  check(timeout);
  if (!is_connect()) {
    return -1;
  }

  int len = (recv_buffer->size() > maxlen) ? maxlen : recv_buffer->size();
  if (len == 0) {
    return 0;
  }
  recv_buffer->get((unsigned char *)area, len);

  return len;
#else
  return -1;
#endif
}


int TcpipDevice::send(const void *area, unsigned long len) {
#ifdef HAVE_LIBSDL_NET
  check(0);
  if (!is_connect()) {
    return -1;
  }
  
  return SDLNet_TCP_Send(tcp_socket, (void *)area, len);
#else
  return -1;
#endif
}


int TcpipDevice::copy(void *area, unsigned long len) {
#ifdef HAVE_LIBSDL_NET
  return recv_buffer->copy((unsigned char *)area, len);
#else
  return -1;
#endif
}


/*!
  \brief Mf[^̔j

  \attention MǂłȂf[^j
*/
void TcpipDevice::flush(void) {
#ifdef HAVE_LIBSDL_NET
  recv_buffer->clear();
#endif
}


long TcpipDevice::size(void) {
#ifdef HAVE_LIBSDL_NET
  check(0);
  return recv_buffer->size();
#else
  return 0;
#endif
}
