#ifndef URG_MANUAL_CAPTURE_H
#define URG_MANUAL_CAPTURE_H

/*!
  \file
  \brief kzd@ ZT URG-X002, URG-X003 ̃f[^擾NX

  \author Satofumi KAMIMURA
  
  $Id$
*/

#include "urgCapture.h"
#include "connectionDevice.h"
#include "dll_macro.h"


/*!
  \brief ZT̋@\
*/
class DECLSPEC URGManualCapture : public URGCapture {
  enum {
    URG_TYPE_UNKNOWN,
    URG_PROD_X_002,
    URG_PROD_X_003,
    URG_PROT_1_0,
    URG_PROT_1_0Z,
    URG_SERI_BUFMAX = 80,
  };
  
  ConnectionDevice *con;
  int capture_times;
  int product_version;
  int protocol_version;
  int data_byte_size;

  void swap(int *a, int *b);
  bool isLF(char ch);
  unsigned char encode6bit(char ch);
  int checkProtocolVersion(ConnectionDevice* con);
  void skipToLF(ConnectionDevice* con);
  int adjustIndex(int index, int add);
  bool isHandstand;
  char *serialId;
  char serialId_buffer[URG_SERI_BUFMAX];
  
public:
  URGManualCapture(void);
  ~URGManualCapture(void);
  int connect(const char *deviceName, long baudrate);
  int connectSimulator(const char *host, int port);
  void disconnect(void);
  bool is_connect(void);
  int get_captureTimes(void);
  int capture(long *data, int from, int to, int group);
  int capture(long *data, int group);
  void laser(bool on);
  bool setLongRangeMode(bool on);
  const char* getURGSerialName(void);
  const char* getURGProductName(void);
  const char* getURGProtocolName(void);
  void setHandstand(bool on);
  bool isLongRangeMode(void);
  int getMesurableMax(void);
};

#endif /* !URG_MANUAL_CAPTURE_H */
