#ifndef VXV_URG_CTRL_H
#define VXV_URG_CTRL_H

/*
  URGCtrl ɂĂ̋ʃC^[tF[X
  Satofumi KAMIMURA
  $Id$
*/

#include "vxvUtils.h"
#include "dll_macro.h"
#include <vector>


/*!
  \brief URG ZT̃C^[tF[X
*/
class DECLSPEC VXV_URGCtrl {
protected:
  /*!
    \brief convert2D ̌ʂi[Reiւ̎QƂԂ
    \param Ȃ
  */
  virtual std::vector<VXV_Grid2D>& getGrid2DObj(void) = 0;

  /*!
    \brief convert2D ̌ʂi[Reiւ̎QƂԂ
    \param Ȃ
  */
  virtual std::vector<VXV_Grid3D>& getGrid3DObj(void) = 0;
  
public:
  virtual ~VXV_URGCtrl(void) {}

  /*!
    \brief R}hCw̐ڑfoCXɐڑ
    
    vOs̈Ŏw肳ꂽfoCXւ̐ڑ݂BڑɎsꍇA URGCtrl::connect(bool autoCapture) ̕]s
    
    Ŏwł鍀ڂ͈ȉ̒ʂ
    \li --urg_port=<foCX>
    \li --urg_baudrate=<{[[g>
    \li --urg_handstand URG VntŎgpĂꍇ
    
    --urg_port ɂfoCX "auto" ̏ꍇAURG_AUTO_PORT ̒TfoCXԍ 20  0 Ɍčs
    
    \param argc [i] main() argc
    \param argv [i] main() argv
    \param autoCapture [i] f[^̎擾[h(URGCapture Q)
    \retval 0 I
    \retval < 0 G[ (URG::RETURN_VALUE)
  */
  virtual int connect(int argc, char *argv[], bool autoCapture = true) = 0;


  /*!
    \brief ZTƂ̐ڑ
    
    \param Ȃ
  */
  virtual void disconnect(void) = 0;


  /*!
    \brief ZTƂ̐ڑԂԂ
    
    \param Ȃ
    \retval true ڑĂ
    \retval false ڑĂȂ
  */
  virtual bool is_connect(void) = 0;


  /*!
    \brief \ȋԂ
    
    \param Ȃ
    \retval \ȋ [mm]
  */
  virtual long get_mesurableMax(void) = 0;


  /*!
    \brief ZTf[^擾
    
    ZTf[^擾AURGCtrl::length[] Ɋi[Bڍׂ URGCapture::capture() QƂ̂
    
    \param from [i] Jnindex
    \param to [i] Iindex
    \param group [i] O[sOsf[^
    \retval *this
  */
  virtual VXV_URGCtrl& capture(int from, int to, int group = 1) = 0;


  /*!
    \brief ➑̂ɑ΂ZT̎tʒu𒲐
    
    ZT➑̒Sɑ΂tʒuݒ肷BŐݒ肵ĺAconvert() ̌vZ̍ۂɍlB
    
    \param x [i] Xl [mm]
    \param y [i] Yl [mm]
    \param t [i] px
    \retval *this
  */
  virtual VXV_URGCtrl& setURGOffset(int x, int y, VXV_Direction t) = 0;


  /*!
    \brief ZT̓񎟌Wʒuݒ
    
    URGCtrl2D::convert() ł́AŐݒ肵WnɊÂđ_̍WvZB
    
    \param x [i] XWl[mm]
    \param y [i] YWl[mm]
    \param t [i] px
    \retval *this
  */
  virtual VXV_URGCtrl& setPosition(int x, int y, VXV_Direction t) = 0;


  /*!
    \brief ZT̓񎟌Wʒuݒ

    URGCtrl2D::convert() ł́AŐݒ肵WnɊÂđ_̍WvZB
    
    \param position [i] ʒu [VXV_Position]
    \retval *this
  */
  virtual VXV_URGCtrl& setPosition(VXV_Position& position) = 0;


  /*!
    \brief 擾f[^_̈ʒu񎟌Wɕϊ
    
    URGCtrl2D::length[] ̃f[^Ή URGCtrl2d::grid2d[] ɕϊقALȃf[^ URGCtrl2D::grid2d_vector Ɋi[B
    
    \param Ȃ
    \retval *this
  */
  virtual VXV_URGCtrl& convert2D(void) = 0;


  /*!
    \brief ZT̓񎟌Wʒuݒ肵A擾f[^_񎟌Wɕϊ
    
    URGCtrl2D::convert2D(), URGCtrl2D::setPosition() QƂ̂ƁB
    
    \param x [i] XWl[mm]
    \param y [i] YWl[mm]
    \param t [i] px
    \retval *this
  */
  virtual VXV_URGCtrl& convert2D(int x, int y, VXV_Direction t) = 0;


  /*!
    \brief ➑̂ɑ΂ZT̎tʒu𒲐
    
    ZT➑̒Sɑ΂tʒuݒ肷BŐݒ肵ĺAconvert() ̌vZ̍ۂɍlB
    
    \param position [i] ʒu [VXV_Position]
    \retval *this
  */
  virtual VXV_URGCtrl& convert2D(VXV_Position& position) = 0;


  /*!
    \brief ZT[➑̂̑Έʒu
    
    ➑̒S̑ΈʒuApxݒ肷
    
    \param x [i] Έʒu X [mm]
    \param y [i] Έʒu Y [mm]
    \param z [i] Έʒu Z [mm]
    \param dx [i] Ίpx X ܂ [VXV_Direction]
    \param dy [i] Ίpx Y ܂ [VXV_Direction]
    \param dz [i] Ίpx Z ܂ [VXV_Direction]
  */
  virtual VXV_URGCtrl& setURGOffset(int x, int y, int z,
				    VXV_Direction dx,
				    VXV_Direction dy,
				    VXV_Direction dz) = 0;


  /*!
    \brief ZT̎OWʒuݒ
    
    URGCtrl3D::convert() ł́AŐݒ肵WnɊÂđ_̍WvZB
    
    \param x [i] XWl [mm]
    \param y [i] YWl [mm]
    \param z [i] ZWl [mm]
    \param dx [i] X܂̊px [VXV_Direction]
    \param dy [i] Y܂̊px [VXV_Direction]
    \param dz [i] Z܂̊px [VXV_Direction]
    \retval *this
  */
  virtual VXV_URGCtrl& setPosition(int x, int y, int z,
				   VXV_Direction dx,
				   VXV_Direction dy,
				   VXV_Direction dz) = 0;


  /*!
    \brief 擾f[^_̈ʒuOWɕϊ
    
    URGCtrl3D::length[] ̃f[^Ή URGCtrl3d::grid3d[] ɕϊقALȃf[^ URGCtrl3D::grid3d_vector Ɋi[B
    
    \param Ȃ
    \retval *this
  */
  virtual VXV_URGCtrl& convert3D(void) = 0;


  /*!
    \brief 擾f[^_̈ʒuOWɕϊ
    
    URGCtrl3D::length[] ̃f[^Ή URGCtrl3d::grid3d[] ɕϊقALȃf[^ URGCtrl3D::grid3d_vector Ɋi[Bϊ̍ۂɁÃ݂ZTʒuXVB
    
    \param x [i] XWl [mm]
    \param y [i] YWl [mm]
    \param z [i] ZWl [mm]
    \param dx [i] X܂̊px [VXV_Direction]
    \param dy [i] Y܂̊px [VXV_Direction]
    \param dz [i] Z܂̊px [VXV_Direction]
    \retval *this
  */
  virtual VXV_URGCtrl& convert3D(int x, int y, int z,
				 VXV_Direction dx,
				 VXV_Direction dy,
				 VXV_Direction dz) = 0;
};

#endif /* !VXV_URG_CTRL_H */
