/*
  kzd@ ZT URG-X002S ̂QcNX
  Satofumi KAMIMURA
  $Id$
*/

#include "urgCtrl2D.h"
#include <math.h>


/*!
  \brief IuWFNg̐

  ZTɖڑȃIuWFNg𐶐B

  \par gp
  \code
  #include <urgCtrl2D.h>
  using namespace URG;
  
  int main(int argc, char *argv[]) {
    URGCtrl2D urg = URGCtrl2D();
    if (urg.connect(argc, argv) < 0) {
      printf("urg.connect: %s\n", urg.getError());
      return 1;
    }
    ...
  \endcode
*/
URGCtrl2D::URGCtrl2D(void) {
  base.x = 0;
  base.y = 0;
  base.t.div16 = 0;
  sensor_offset.x = 0;
  sensor_offset.y = 0;
  sensor_offset.t.div16 = 0;
  grid2D_vector.clear();
}


URGCtrl2D::~URGCtrl2D(void) {
  disconnect();
}


/*!
  \brief ZTf[^擾

  URGCtrl::capture() QƂ̂ƁB
  
  \param from [i] Jnindex
  \param to [i] Iindex
  \param group [i] O[sOsf[^
  \retval *this

  \par gp
  \code
  #include <urgCtrl2D.h>
  using namespace URG;
  
  int main(int argc, char *argv[]) {
    URGCtrl2D urg = URGCtrl2D();
    if (urg.connect(argc, argv) < 0) {
      printf("urg.connect: %s\n", urg.getError());
      return 1;
    }
    // O -45[deg]  45[deg]܂ł͈̔͂̃f[^擾
    urg.capture(URG::deg2index(-45), URG::deg2index(45));
    ...
  }
  \endcode
*/
URGCtrl2D& URGCtrl2D::capture(int from, int to, int group) {
  URGCtrl::capture(from, to, group);
  return *this;
}


/*!
  \brief ZTf[^擾

  URGCtrl::capture() QƂ̂ƁB
  
  \param group [i] O[sOsf[^
  \retval *this
*/
URGCtrl2D& URGCtrl2D::capture(int group) {
  URGCtrl::capture(0, URG::DATA_SIZE-1, group);
  return *this;
}


/*!
  \brief ZT̓񎟌Wʒuݒ

  URGCtrl2D::convert() ł́AŐݒ肵WnɊÂđ_̍WvZB

  \param x [i] XWl[mm]
  \param y [i] YWl[mm]
  \param degree [i] px[degree]
  \retval *this

  \attention VXV_Direction p\bhgp邱
*/
URGCtrl2D& URGCtrl2D::setPosition(int x, int y, int degree) {
  return setPosition(x, y, deg(degree));
}


/*!
  \brief ZT̓񎟌Wʒuݒ

  URGCtrl2D::convert() ł́AŐݒ肵WnɊÂđ_̍WvZB

  \param x [i] XWl[mm]
  \param y [i] YWl[mm]
  \param t [i] px
  \retval *this
*/
URGCtrl2D& URGCtrl2D::setPosition(int x, int y, VXV_Direction t) {
  base.x = x;
  base.y = y;
  base.t.div16 = t.div16;
  
  return *this;
}


/*!
  \brief ZT̓񎟌Wʒuݒ

  URGCtrl2D::convert() ł́AŐݒ肵WnɊÂđ_̍WvZB

  \param position [i] ʒu [VXV_Position]
  \retval *this
*/
URGCtrl2D& URGCtrl2D::setPosition(VXV_Position& position) {
  return setPosition(position.x, position.y, position.t);
}					       


/*!
  \brief 擾f[^_̈ʒu񎟌Wɕϊ

  URGCtrl2D::length[] ̃f[^Ή URGCtrl2d::grid2d[] ɕϊقALȃf[^ URGCtrl2D::grid2d_vector Ɋi[B

  \param Ȃ
  \retval *this

  gp
  \code
  urg.capture().convert2D();
  
  // grid2d[] gꍇ
  for (int i = 0; i < URG::SENSE_MAX; ++i) {
    if (urg.length[i] >= 20) {
      printf("x: %d, y: %d\n", urg.grid2d[i].x, urg.grid2d[i].y);
    }
  }

  // vector gꍇ
  for (vector<URGCtrl2D::grid2d_t>::iterator it = urg.grid2d_vector.begin();
       it != urg.grid2d_vector.end(); ++it) {
    printf("x: %d, y: %d\n", it->x, it->y);
  }
  \endcode
*/
URGCtrl2D& URGCtrl2D::convert2D(void) {
  grid2D_vector.clear();
  
  if (!is_captured) {
    for (int i = 0; i < URG::DATA_SIZE; ++i) {
      grid2D[i].x = -1;
      grid2D[i].y = -1;
    }
    return *this;
  }

  double base_rad = URG::deg2rad(base.deg());
  int sensor_x = base.x +
    (int)(sensor_offset.x * cos(base_rad) - sensor_offset.y * sin(base_rad));
  int sensor_y = base.y +
    (int)(sensor_offset.x * sin(base_rad) + sensor_offset.y * cos(base_rad));
  double sensor_rad = base_rad + URG::deg2rad(sensor_offset.deg());
  for (int i = 0; i < URG::DATA_SIZE; ++i) {
    if ((length[i] < 20) ||
	(mode && !mode->isLongRangeMode() &&
	 (length[i] >= URGCtrl::mesurable_max))) {
      grid2D[i].x = -1;
      grid2D[i].y = -1;
      continue;
    }
    double rad = sensor_rad + URG::index2rad(i);
    VXV_Grid2D point;
    point.x = sensor_x + (int)(length[i] * cos(rad));
    point.y = sensor_y + (int)(length[i] * sin(rad));
    grid2D[i] = point;
    grid2D_vector.push_back(point);
  }
  return *this;
}


/*!
  \brief ZT̓񎟌Wʒuݒ肵A擾f[^_񎟌Wɕϊ

  URGCtrl2D::convert2D(), URGCtrl2D::setPosition() Q

  \param x [i] XWl[mm]
  \param y [i] YWl[mm]
  \param degree [i] px[degree]
  \retval *this

  gp
  \code
  // setPosition()  convert2D() ʁXɎw
  urg.capture().setPosition(x, y, degree).convert2D();

  // setPosition()  convert2D()  convert2D(x, y, degree) őp
  urg.capture().convert2D(x, y, degree);
  \endcode


  \attention ȂׂAVXV_Direction p\bhgĉ
*/
URGCtrl2D& URGCtrl2D::convert2D(int x, int y, int degree) {
  return setPosition(x, y, deg(degree)).convert2D();
}


/*!
  \brief ZT̓񎟌Wʒuݒ肵A擾f[^_񎟌Wɕϊ

  URGCtrl2D::convert2D(), URGCtrl2D::setPosition() QƂ̂ƁB

  \param x [i] XWl[mm]
  \param y [i] YWl[mm]
  \param t [i] px
  \retval *this

  gp
  \code
  // setPosition()  convert2D() ʁXɎw
  urg.capture().setPosition(x, y, degree).convert2D();

  // setPosition()  convert2D()  convert2D(x, y, degree) őp
  urg.capture().convert2D(x, y, degree);
  \endcode
*/
URGCtrl2D& URGCtrl2D::convert2D(int x, int y, VXV_Direction t) {

  sensor_offset.x = x;
  sensor_offset.y = y;
  sensor_offset.t.div16 = t.deg();

  return setPosition(x, y, t).convert2D();
}


/*!
  \brief ➑̂ɑ΂ZT̎tʒu𒲐

  \param x [i] Xl [mm]
  \param y [i] Yl [mm]
  \param degree [i] px [degree]
  \retval *this

  \attention ȂׂAVXV_Direction p\bhgĉ
*/
URGCtrl2D& URGCtrl2D::setURGOffset(int x, int y, int degree) {
  return setURGOffset(x, y, deg(degree));
}


/*!
  \brief ➑̂ɑ΂ZT̎tʒu𒲐

  ZT➑̒Sɑ΂tʒuݒ肷BŐݒ肵ĺAconvert() ̌vZ̍ۂɍlB

  \param x [i] Xl [mm]
  \param y [i] Yl [mm]
  \param t [i] px
  \retval *this
*/
URGCtrl2D& URGCtrl2D::setURGOffset(int x, int y, VXV_Direction t) {

  sensor_offset.x = x;
  sensor_offset.y = y;
  sensor_offset.t.div16  = t.div16;

  return *this;
}


/*!
  \brief ➑̂ɑ΂ZT̎tʒu𒲐

  ZT➑̒Sɑ΂tʒuݒ肷BŐݒ肵ĺAconvert() ̌vZ̍ۂɍlB

  \param position [i] ʒu [VXV_Position]
  \retval *this
*/
URGCtrl2D& URGCtrl2D::convert2D(VXV_Position& position) {
  return convert2D(position.x, position.y, position.t);
}

