/*
  kzd@ ZT URG-X002S ̊{NX
  Satofumi KAMIMURA
  $Id$
*/

#include "config.h"
#include "urgCtrl.h"
#include "urgManualCapture.h"


enum {
  NO_FILE_ERROR = -2,
};


void URGCtrl::initLength(void) {
  for (int i = 0; i < URG::DATA_SIZE; ++i) {
    length[i] = -1;
  }
}


/*!
  \brief IuWFNg̐

  ZTɖڑȃIuWFNg𐶐B

  \param Ȃ

  \par gp
  \code
  #include <urgCtrl.h>
  using namespace URG;
  
  int main(int argc, char *argv[]) {
    URGCtrl urg = URGCtrl();
    if (urg.connect(argc, argv) < 0) {
      printf("urg.connect: %s\n", urg.getError());
      exit(1);
    }
  ...
  }
  \endcode
*/
URGCtrl::URGCtrl(void)
  : mode(NULL), error_message("connection device is not specified"),
    error_device(""), error_baudrate(0), isHandstand(false),
    mesurable_max(-1) {
  initLength();
}


/*!
  \brief f[^̎擾NXw̃IuWFNg

  URGCapture ̎w肵ăIuWFNg𐶐

  \param captureMode [i] URGCapture ̎

  \par gp
  \code
  #include <urgCtrl.h>
  using namespace URG;
  
  int main(int argc, char *argv[]) {
    URGCapture *mode = new URGManualCapture(); // 擾
    //URGCapture *mode = new URGAutoCapture(); // 擾
    URGCtrl urg = URGCtrl(mode);
    if (urg.connect("/dev/ttyS0") < 0) {
      printf("urg.connect: %s\n", urg.getError());
      exit(1);
    }
    ...
  }
  \endcode
*/
URGCtrl::URGCtrl(URGCapture *captureMode)
  : error_message("URGCapture object is invalid"
		  " or connection device is not specified."),
    error_device(""), error_baudrate(0) {
  mode = captureMode;
  initLength();
}


URGCtrl::~URGCtrl(void) {
  if (mode) {
    delete mode;
  }
}


/*!
  \brief G[bZ[WԂ

  \param Ȃ
  \retval error_message G[bZ[Wւ̃|C^

  gp
  \code
  #include <urgCtrl.h>
  using namespace URG;

  int main(int argc, char *argv[]) {
    URGCtrl urg = URGCtrl();
    if (urg.connect(argc, argv) < 0) {
      printf("URG: %s\n", urg.getError());
      exit(1);
    }
    ...
  }
  \endcode
*/
const char *URGCtrl::getError(void) {
  int message_length = 11 + strlen(error_device) + strlen(error_message) + 5;
  if ((message_length > ERROR_MESSAGE_BUFFER_SIZE) ||
      (error_device[0] == '\0')) {
    return error_message;
  }
  sprintf(error_message_buffer, "%s, %ld : %s",
	  error_device, error_baudrate, error_message);
  return error_message_buffer;
}


/*!
  \brief ZTւ̐ڑs

  \param deviceName [i] foCXւ̃|C^
  \param baudrate [i] {[[g
  \param autoCapture [i] f[^̎擾[h(URGCapture Q)
  \retval 0 I
  \retval < 0 G[(URG::RETURN_VALUE)

  gp
  \code
  URGCtrl urg = URGCtrl();
  if (urg.connect("/dev/ttyS0", 115200) < 0) {
    printf("URG: %s\n", urg.getError());
    exit(1);
  }
  urg.capture();
  \endcode
*/
int URGCtrl::connect(const char *deviceName, long baudrate,
		     bool autoCapture) {
  if (mode && mode->is_connect()) {
    delete mode;
  }
  if (!mode) {
#ifdef HAVE_LIBSDL
    if (autoCapture) {
      mode = new URGAutoCapture();
    } else {
      mode = new URGManualCapture();
    }
#else
    if (autoCapture) {
      error_device = "";
      error_message =
	"auto capture mode: not installed SDL."
	"  please reinstall SDL, and vxv_tools(urg)"
	"  or use manual capture mode";
    }
    mode = new URGManualCapture();
#endif
  }
  int ret_value = mode->connect(deviceName, baudrate);
  strncpy(error_device_buffer, deviceName, ERROR_MESSAGE_BUFFER_SIZE-1);
  error_device = error_device_buffer;
  error_baudrate = baudrate;
  if (ret_value < 0) {
    delete mode;
    mode = NULL;
    
    if (ret_value == URG::DEVICE_OPEN_ERROR) {
      error_message = "specified device is invalid";
      
    } else if (ret_value == URG::BAUDRATE_ADJUST_ERROR) {
      error_message =
	"adjust baudrate is fail."
	" Is device connected to URG ?";
      
    } else if (ret_value == URG::PRODUCT_MISMATCH_ERROR) {
      error_message = "connected sensor is not URG";
      
    } else {
      error_message = "unknown error";
    }
  } else {
    setHandstand(isHandstand);
    mesurable_max = mode->getMesurableMax();
    error_message = "success";
  }

  return ret_value;
}


int URGCtrl::searchConfigFile(const char *path, bool autoCapture) {
  int path_length = strlen(path);
  int file_length = strlen(URG_CONFIG_FILE);
  char *file_path = new char[path_length + 1 + file_length + 1];
  strcpy(file_path, path);
  strcpy(&file_path[path_length], "/");
  strcpy(&file_path[path_length +1], URG_CONFIG_FILE);
  file_path[path_length + 1 + file_length] = '\0';

  long baudrate = URG::BAUDRATE;
  char *baudrate_str;
  char *deviceName;
  if ((baudrate_str = get_keyword(file_path, "urg_baudrate"))) {
    baudrate = atoi(baudrate_str);
    free(baudrate_str);
  }
  char *handstand;
  if ((handstand = get_keyword(file_path, "urg_handstand"))) {
    setHandstand(true);
    free(handstand);
  }
  deviceName = get_keyword(file_path, "urg_port");
  delete file_path;
  if (deviceName) {
    int ret_value = connect(deviceName, baudrate, autoCapture);
    free(deviceName);
    return ret_value;
  }
  return NO_FILE_ERROR;
}



/*!
  \brief ZTւ̐ڑs

  ڑfoCXA
  \li vOsĂfBNg URG_CONFIG_FILE t@C
  \li $HOME fBNg URG_CONFIG_FILE t@C
  \li ϐ URG_PORT
  
  ̏ɒTAŏɌfoCXɐڑ݂BڑɎsꍇATŒfăG[Ԃ

  \param autoCapture [i] f[^̎擾[h(URGCapture Q)
  \retval 0 I
  \retval < 0 G[ (URG::RETURN_VALUE)

  gp
  \code
  // URG_CONFIG_FILE  "b5conf.txt" ̏ꍇ
  URGCtrl urg = URGCtrl();
  if (urg.connect() < 0) {
    // ڑG[A./b5conf.txt, $HOME/b5conf.txt, $VXV_PORT ̕]Ɏs
    printf("URG: %s\n", urg.getError());
    exit(1);
  }
  urg.capture();
  \endcode
*/
int URGCtrl::connect(bool autoCapture) {

  int ret_value = searchConfigFile(".", autoCapture);
  if ((ret_value >= 0) || (ret_value != NO_FILE_ERROR)) {
    return ret_value;
  }

  char *home = getenv("HOME");
  if (home) {
    ret_value = searchConfigFile(home, autoCapture);
    // !!! free Kv͂̂H
    if ((ret_value >= 0) || (ret_value != NO_FILE_ERROR)) {
      return ret_value;
    }
  }

  long baudrate = URG::BAUDRATE;
  char *deviceName = NULL;
  char *baudrate_str = NULL;
  if ((baudrate_str = getenv("URG_BAUDRATE"))) {
    baudrate = atoi(baudrate_str);
  }

  if (getenv("URG_HANDSTAND")) {
    setHandstand(true);
  }
  
  deviceName = getenv("URG_PORT");
  if (deviceName) {
    return connect(deviceName, baudrate, autoCapture);
  }
  return -1;
}


/*!
  \brief R}hCw̐ڑfoCXɐڑ

  vOs̈Ŏw肳ꂽfoCXւ̐ڑ݂BڑɎsꍇA URGCtrl::connect(bool autoCapture) ̕]s

  Ŏwł鍀ڂ͈ȉ̒ʂ
  \li --urg_port=<foCX>
  \li --urg_baudrate=<{[[g>
  \li --urg_handstand URG VntŎgpĂꍇ

  --urg_port ɂfoCX "auto" ̏ꍇAURG_AUTO_PORT ̒TfoCXԍ 20  0 Ɍčs

  \param argc [i] main() argc
  \param argv [i] main() argv
  \param autoCapture [i] f[^̎擾[h(URGCapture Q)
  \retval 0 I
  \retval < 0 G[ (URG::RETURN_VALUE)

  gp
  \code
  // URG_AUTO_PORT  "/dev/ttyS%d" ̏ꍇA--urg_port=auto ɂ /dev/ttyS20  /dev/ttyS0 ܂łɕ]
  #include <urgCtrl.h>
  using namespace URG;
  
  int main(int argc, char *argv[]) {
    URGCtrl urg = URGCtrl();
      if (urg.connect(argc, argv)) {
      printf("URG: %s\n", urg.getError());
      exit(1);
    }
    urg.capture();
    ...
  }
  \endcode
*/
int URGCtrl::connect(int argc, char *argv[], bool autoCapture) {
  long baudrate = URG::BAUDRATE;
  char *deviceName = NULL;

  for (int i = 0; i < argc; ++i) {
    if (!strncmp("--urg_port=", argv[i], 11) && (strlen(argv[i]) > 11)) {
      deviceName = &argv[i][11];
      
    } else if (!strncmp("--urg_baudrate=", argv[i], 15) &&
	       (strlen(argv[i]) > 15)) {
      baudrate = atoi(&argv[i][15]);
      
    } else if (!strncmp("--urg_handstand", argv[i], 15)) {
      isHandstand = true;
      
    } else if (!strcmp("-s", argv[i]) || !strcmp("--simulator", argv[i])) {
      // V~[^(TCP/IP) ւ̐ڑ
#ifdef HAVE_LIBSDL
      if (autoCapture) {
	mode = new URGAutoCapture();
      } else {
	mode = new URGManualCapture();
      }
#else
# ifdef HAVE_LIBSDL_NET
      error_device = "";
      error_message =
	"simulator mode: need SDL_net."
	"  please reinstall SDL_net, and vxv_tools(urg)";
# endif
      mode = new URGManualCapture();
#endif
      setHandstand(true);
      return mode->connectSimulator("localhost", 9763);
    }
  }

  if (deviceName &&
      (!strcmp("auto", deviceName) || !strcmp("AUTO", deviceName))) {
    int ret_value;
    for (int id = 20; id >= 0; --id) {
      char checkDevice[16] = { '\0','\0','\0','\0','\0','\0','\0','\0',
			       '\0','\0','\0','\0','\0','\0','\0','\0' };
      sprintf(checkDevice, URG_AUTO_PORT "%d", id);
      ret_value = connect(checkDevice, baudrate, autoCapture);
      if (ret_value >= 0) {
	break;
      }
    }
    if (ret_value < 0) {
      strncpy(error_device_buffer, URG_AUTO_PORT, ERROR_MESSAGE_BUFFER_SIZE-1);
      error_device = error_device_buffer;
      error_baudrate = baudrate;
      error_message = "auto dvice detection is fail";
    } else {
      error_message = "success";
    }
    return ret_value;
  }

  if (!deviceName) {
    return connect(autoCapture);
  }
  return connect(deviceName, baudrate, autoCapture);
}


/*!
  \brief ZTƂ̐ڑ
  
  \param Ȃ

  \par gp
  \code
  #include <urgCtrl.h>
  using namespace URG;
  
  int main(int argc, char *argv[]) {
    URGCtrl urg = URGCtrl();
    if (urg.connect(argc, argv) < 0) {
      printf("urg.connect: %s\n", urg.getError());
      exit(1);
    }
    
    ...

    urg.disconnect();
  }
  \endcode
*/
void URGCtrl::disconnect(void) {
  mode->disconnect();
}


/*!
  \brief ZTƂ̐ڑԂԂ

  \param Ȃ
  \retval true ڑĂ
  \retval false ڑĂȂ

  \par gp
  \code
  #include <urgCtrl.h>
  using namespace URG;
  
  int main(int argc, char *argv[]) {
    URGCtrl urg = URGCtrl();
    if (!urg.connect(argc, argv).is_connect()) {
      printf("urg.connect: %s\n", urg.getError());
      exit(1);
    }
    ...
  }
  \endcode
*/
bool URGCtrl::is_connect(void) {
  return mode && mode->is_connect();
}


/*!
  \brief f[^ZT擾񐔂擾
  
  ̃\bh́AURGAutoCapture Ŏ擾f[^̎ʂ邽߂ɗpB擾񐔂̓IuWFNg 0 ɏB
  
  \param Ȃ
  \retval ZTf[^擾

    \par gp
    \code
    URGCtrl urg = URGCtrl();
    for (int i = 0; i < 20; ++i) {
      // times ̒lقȂ΁AقȂ^C~Ȏf[^
      printf("times: %d\n", urg.capture().get_captureTimes());
    }
    \endcode
*/
int URGCtrl::get_captureTimes(void) {
  return mode->get_captureTimes();
}


/*!
  \brief ZTf[^擾

  ZTf[^擾AURGCtrl::length[] Ɋi[Bڍׂ URGCapture::capture() QƂ̂

  \param from [i] Jnindex
  \param to [i] Iindex
  \param group [i] O[sOsf[^
  \retval *this

  gp
  \code
  urg.capture();
  for (int i = 0; i < URG::DATA_SIZE; ++i) {
    printf("%3d[deg] : %4d[mm]\n", URG::index2deg(i), urg.length[i]);
  }
  \endcode
*/
URGCtrl& URGCtrl::capture(int from, int to, int group) {
  is_captured = (mode->capture(length, from, to, group) < 0) ? false : true;
  return *this;
}


#if 0
/*!
  \brief ZTf[^擾

  \attention ̃\bh͉ʌ݊̂߂ɑ݂BURGCtrl::capture() gp邱
*/
int URGCtrl::getData(unsigned short data[], int begin, int end,
		     int groupSize) {
  long captureData[URG::DATA_SIZE];
  int n = mode->capture(captureData, begin, end, groupSize);
  for (int i = 0; i < n; ++i) {
    data[i] = (captureData[i] >= 65535) ? 65535 : data[i];
  }
  return n;
}
#endif


/*!
  \brief ZTf[^擾

  S͈͂̃f[^擾sBURGCtrl::capture() QƂ̂

  \param group [i] O[sOsf[^
*/
URGCtrl& URGCtrl::capture(int group) {
  is_captured = (mode->capture(length, 0, URG::DATA_SIZE, group) < 0)
    ? false : true;
  return *this;
}


#if 0
/*!
  \brief ZTf[^擾

  \attention ̃\bh͉ʌ݊̂߂ɑ݂BURGCtrl::capture() gp邱
*/
int URGCtrl::getData(unsigned short data[], int groupSize) {
  return getData(data, 0, URG::DATA_SIZE, groupSize);
}
#endif


/*!
  \brief ԊO[U[̓_𐧌

  URGCapture::laser() QƂ̂ƁB

  \param on [i] URG::ON _w / URG::OFF w
*/
void URGCtrl::laser(bool on) {
  mode->laser(on);
}


/*!
  \brief ZT̃VAԂ

  URGCapture::getURGSerialName QƂ̂

  \param Ȃ
  \retval ւ̃|C^
*/
const char* URGCtrl::getURGSerialName(void) {
  if (mode) {
    return mode->getURGSerialName();
  } else {
    return "Not connected";
  }
}

/*!
  \brief ZŤ^Ԃ

  URGCapture::getURGProductName QƂ̂ƁB

  \param Ȃ
  \retval ZT^ւ̃|C^
  \retval "Not connected." ڑ
  \retval "Unknown Product type" Ɏs
  \retval "SOKUIKI Sensor URG-X002" URG-X002 4[m] o[W
  \retval "SOKUIKI Sensor URG-X003" URG-X003 4[m], 10[m] o[W
*/
const char* URGCtrl::getURGProductName(void) {
  if (mode) {
    return mode->getURGProductName();
  } else {
    return "Not connected";
  }
}


/*!
  \brief ZŤ^Ԃ

  URGCapture::getURGProtocolName QƂ̂ƁB

  \param Ȃ
  \retval ZT^ւ̃|C^
  \retval "Not connected." ڑ
  \retval "Unknown Product type" Ɏs
  \retval "SOKUIKI Sensor URG-X002" URG-X002 4[m] o[W
  \retval "SOKUIKI Sensor URG-X003" URG-X003 4[m], 10[m] o[W
*/
const char* URGCtrl::getURGProtocolName(void) {
  if (mode) {
    return mode->getURGProtocolName();
  } else {
    return "Not connected";
  }
}


/*!
  \brief 胂[h(4[m],10[m]) ̕ύXs

  URGCapture::setLongRangeMode() QƂ̂ƁB

  \param on [i] URG::ON 10[m]胂[h / URG::OFF 4[m]胂[h
  \retval true I
  \retval false ύXɎs
*/
bool URGCtrl::setLongRangeMode(bool on) {
  if (mode) {
    bool ret = mode->setLongRangeMode(on);
    mesurable_max = mode->getMesurableMax();
    return ret;
  }
  return false;
}


/*!
  \brief ZT̎tԂ̐ݒ
  
  ꍇɂẮAZTVntɎtĎgpĂꍇB̃\bhŎtԂݒ肷ƁA擾ꂽf[^̔zutŊi[B
  
  \param on [i] VntŎtĂꍇ true
  \retval *this
*/
URGCtrl& URGCtrl::setHandstand(bool on) {
  isHandstand = on;
  if (mode) {
    mode->setHandstand(on);
  }
  return *this;
}


long URGCtrl::get_mesurableMax(void) {
  return mesurable_max;
}
