/*
  kzd@ ZT URG-X002S ̑C^[tF[X
  Satofumi KAMIMURA
  $Id$
*/

#include "urgCapture.h"
#include <math.h>
#include "math_util.h"


int URG::deg2index(const int degree) {

  int sense_deg = ((degree % 360) + 360) % 360;
  if (sense_deg > 180) {
    sense_deg = sense_deg - 360;
  }
  int index = (int)((135 - sense_deg) / (360.0/1024.0));
  if (index < 0) {
    index = 0;
  } else if (index > URG::DATA_SIZE-1) {
    index = URG::DATA_SIZE-1;
  }
  
  return index;
}


int URG::index2deg(const int index) {
  return (int)(360 * URG::index2rad(index) / (2.0 * M_PI));
}


double URG::index2rad(const int index) {
  static const double rad135 = 2.0 * M_PI * 135.0/360.0;
  
  double rad = rad135 - (index * 2.0 * M_PI / 1024.0);
  if (rad < -rad135) {
    rad = -rad135;
  } else if (rad > rad135) {
    rad = rad135;
  }
  
  return rad;
}


int URG::rad2deg(const double radian) {
  return (int)(360.0 * radian / (2.0 * M_PI));
}


double URG::deg2rad(const int degree) {
  return (2.0 * M_PI * degree / 360.0);
}
