/*
  ʐM
  Satofumi KAMIMURA
  $Id$
*/

#include "connect_device.h"
#include "serial_device.h"
#include "tcpip_device.h"


static int Mode = NOT_SPECIFIED;


void closeDevice(void) {
  if (Mode == TCP_IP) {
    tcpip_close();
    
  } else if (Mode == SERIAL) {
    serial_close();
  }
}
			    

int initConnectDevice(const char *devName, int baudrate, int mode) {
  int ret_value = -1;
  
  if (mode == TCP_IP) {
    ret_value = tcpip_open((unsigned char*)devName, baudrate);
  } else if (mode == SERIAL) {
    ret_value = serial_open(devName, baudrate);
  } else {
    return -1;
  }
  Mode = mode;
  
  return ret_value;
}


int device_is_connect(void) {
  int ret_value = -1;

  if (Mode == TCP_IP) {
    ret_value = tcpip_is_connect();
    
  } else if (Mode == SERIAL) {
    ret_value = serial_is_connect();
  }
  return ret_value;
}


int device_send(const unsigned char *data, int length) {
  int ret_value = -1;

  if (Mode == TCP_IP) {
    ret_value = tcpip_send(data, length);
    
  } else if (Mode == SERIAL) {
    ret_value = serial_send(data, length);
  }
  return ret_value;
}


int device_recv(unsigned char *data, int size, int timeout) {
  int ret_value = -1;
  
  if (Mode == TCP_IP) {
    ret_value = tcpip_recv(data, size, timeout);
    
  } else if (Mode == SERIAL) {
    ret_value = serial_recv(data, size, timeout);
  }
  return ret_value;
}


int device_flush(void) {
  int ret_value = -1;

  if (Mode == TCP_IP) {
    ret_value = 0;
    
  } else if (Mode == SERIAL) {
    ret_value = 0;
    serial_flush();
  }

  return ret_value;
}


int device_set_baudrate(long baudrate) {
  int ret_value = -1;

  if (Mode == TCP_IP) {
    ret_value = 0;
  } else if (Mode == SERIAL) {
    ret_value = serial_set_baudrate(baudrate);
  }

  return ret_value;
}
