#ifndef STRUCT_TABLES_H
#define STRUCT_TABLES_H

// device/
#include "motorCtrl.h"
#include "encCtrl.h"
#include "directCtrl.h"

// framework/
#include "wheelCtrl.h"
#include "directWheelCtrl.h"
#include "bodyCtrl.h"
#include "bodyPosition.h"
#include "velocityInfo.h"
#include "coordinateCtrl_target.h"

// manage
#include "modeCtrl.h"

// control
#include "velocityCtrl.h"


typedef struct {

  // system
  long version;
  int msec;
  long sec;
  unsigned short used_msec;
  
  // device
  encInfo_t enc[2];
  motorInfo_t mtr[2];
  directInfo_t direct[2];

  // framework
  wheelInfo_t whl[2];
  directWheelInfo_t directWhl[2];
  bodyInfo_t bodyInfo;
  bodyPosition_t bodyPos;
  coordinateInfo_t gl_crd;
  coordinateInfo_t gl_crd_offset;
  coordinateInfo_t run_crd;
  coordinateInfo_t run_crd_offset;
  velocityInfo_t velInfo;

  // manage
  modeInfo_t mode;

  // contorl
  velocityCtrlInfo_t straight;
  velocityCtrlInfo_t rotate;
  
} runCtrl_t;

#endif /* !STRUCT_TABLES_H */
