#ifndef SH_7045_LIB_H
#define SH_7045_LIB_H

/*
  SH7045F饤֥
  Satofumi KAMIMURA
  $Id$
*/

#include "sci_init.h"


typedef void (*timerHandler_t)(void);

enum {
  // SCI
#ifndef SCI_BUFFER_SIZE_SHIFT
  SCI_BUFFER_SIZE_SHIFT = 8,
#endif
  SCI_BUFFER_SIZE = 1 << SCI_BUFFER_SIZE_SHIFT,
  SCI_0 = 0,
  SCI_1 = 1,

#ifndef TIMER_HANDLER_MAX
  TIMER_HANDLER_MAX = 16,
#endif
};


#include "cpp_extern_macro.h"
BEGIN_C_DECLS;

extern void set_imask(int mask);
extern int get_imask(void);

extern void init_sci(int port, int level);
extern void stop_sci(int port);
extern int sci_sending(int port);
extern int putstr(int port, const unsigned char *data);
extern int puthex(int port, unsigned long num, int hexwidth);
extern int putnum(int port, int num);
extern int sci_read(int port, unsigned char *data, int size);
extern int sci_copy(int port, unsigned char *data, int size);
extern int get_sciReadable(int port);
extern void flush_sciRecv(int port);

extern void init_timer(int level);
extern int set_timerHandler(timerHandler_t callback, int interval_usec);
extern void unset_timerHandler(timerHandler_t callback);
extern int start_timer(int usec);
extern void stop_timer(void);
extern void getRawCount(unsigned short *cnt);
extern void getTimestamp(unsigned long *msec, unsigned short *usec);

END_C_DECLS;
#endif /* !SH_7045_LIB_H */
