/*
  ꥢ
  Satofumi KAMIMURA
  $Id$
*/

#include "sh7045lib.h"
#include "ringBuffer.h"


int putstr(int port, const unsigned char *data) {
  const unsigned char *p = data;
  
  while (*p != '\0') {
    ++p;
  }
  return sci_write(port, data, p-data);
}


static void reverse(unsigned char *buf) {
  unsigned char *first, *last;
  unsigned char ch;
    
  last = buf;
  while (*last != '\0') {
    last++;
  }
  last--;
    
  for (first = buf; first < last; first++, last--) {
    ch = *first, *first = *last, *last = ch;
  }
}


static int iabs(int num) {
  if (num >= 0) {
    return num;
  } else {
    return -num;
  }
}


static int utoa(unsigned char *buf, unsigned long num, int base) {
  unsigned char *p = buf;
  unsigned int val;
  
  do {
    val = iabs(num % base);
    *p++ = (val > 9) ? (val + 'a' - 10) : (val + '0') ;
    num /= base;
  } while (num != 0);
  *p = '\0';
  reverse(buf);
  
  return p - buf;
}


int puthex(int port, unsigned long num, int hexwidth) {
  char buffer[16] = { '0', '0', '0', '0', '0', '0', '0' };
  int n;

  n = utoa((unsigned char *)&buffer[7], num, 16);
  return sci_write(port, (const unsigned char *)&buffer[7 + n - hexwidth],
		   ((n > hexwidth) ? n : hexwidth));
}


int putnum(int port, int num) {
  unsigned char buffer[12];
  int filled = 0;
  int unum = num;
  int n;

  if (num < 0) {
    buffer[filled++] = '-';
    unum = -num;
  }
  n = utoa(&buffer[filled], unum, 10) + filled;
  return sci_write(port, buffer, n);
}
