#ifndef MODE_CTRL_H
#define MODE_CTRL_H

/*
  䃂[hǗ
  Satofumi KAMIMURA
  $Id$
*/

#include "velocityInfo.h"
#include "velocityCtrl.h"


#ifndef NULL
#define NULL 0x0
#endif


typedef struct {
  int ctrl;
  int straight_ctrl;
  int rotate_ctrl;
  int pre_straight_ctrl;
  int pre_rotate_ctrl;
  int follow_r;
} modeInfo_t;


enum {
  // 䃂[h
  MODE_NO_CTRL = 0,		// Ȃ
  MODE_SERVO_CTRL = 1,		// T[{
  MODE_SERVO_FREE,		// T[{t[
  MODE_DIRECT_CTRL,		// [^xł̒ڐ
  MODE_DIRECT_WHEEL_CTRL,	// ԗփxł̒ڐ

  // i
  MODE_HOLD_VELOCITY_FIRST = 0x100,
  MODE_HOLD_VELOCITY,
  MODE_HOLD_POSITION_FIRST,
  MODE_HOLD_POSITION,
  MODE_STOP_FIRST,
  MODE_STOP,

  // ]
  MODE_HOLD_ROTATE_VELOCITY_FIRST = 0x200,
  MODE_HOLD_ROTATE_VELOCITY,
  MODE_HOLD_ANGLE_FIRST,
  MODE_HOLD_ANGLE,
  MODE_ROTATE_ANGLE_FIRST,
  MODE_ROTATE_ANGLE,
  MODE_FOLLOW_LINE_FIRST,
  MODE_FOLLOW_LINE,
  MODE_FOLLOW_CIRCLE_FIRST,
  MODE_FOLLOW_CIRCLE,
  MODE_ROTATE_STOP_FIRST,
  MODE_ROTATE_STOP,
};


#include "cpp_extern_macro.h"
BEGIN_C_DECLS;

extern void initModeInfo(modeInfo_t *mode);
extern int calcStraightRefVel(velocityCtrlInfo_t *velCtrl, modeInfo_t *mode,
			      bodyPosition_t *bodyPos,
			      velocityInfo_t *velInfo,
			      coordinateInfo_t *run_crd);
extern int calcRotateRefVel(velocityCtrlInfo_t *velCtrl, modeInfo_t *mode,
			    bodyPosition_t *bodyPos, velocityInfo_t *velInfo,
			    coordinateInfo_t *run_crd);

END_C_DECLS;
#endif /* !MODE_CTRL_H */
