#ifndef MOTOR_CTRL_H
#define MOTOR_CTRL_H

/*!
  \file
  \brief [^

  [^̉]s(SH7045Fˑ)

  \author Satofumi KAMIMURA

  $Id: motorCtrl.h,v 1.1 2004/06/09 01:07:20 satofumi Exp $
*/


/*!
  \brief [^p̍\

  [^ɕKvȃp[^Ǘ
*/
typedef struct {
  unsigned char id;		/*!< gp郂[^̃foCXID */
  int gain_p;			/*!< P̃QC [1] */
  int gain_i;			/*!< ĨQC [1/1024] */
  int i_value;			/*!< I̐ϕl */
  int r_per_v;	      /*!< (R / [^d) * ̒萔 */
  int ke_per_v;	    /*!< (tNd͒萔 / [^d) * ̒萔 */
} motorInfo_t;


/*!
  \brief [^̐䃂[h

  [^̐䃂[h
*/
enum MotorMode {
  MTR_MODE_FREE,		/*!< T[{t[ */
  MTR_MODE_CW_BREAK,		/*!< CW  Break ɂ鐧 */
  MTR_MODE_CCW_BREAK,		/*!< CCW  Break ɂ鐧 */
};


/*!
  \brief [^dl

  Maxon ̃J^O
  (222049)
*/
#ifndef MTR_POWER
#define MTR_POWER 12.0		/*!< ̓d [V] */
#endif
#ifndef MTR_OHM
#define MTR_OHM 3.9		/*!< [qԒR [ohm] */
#endif
#ifndef MTR_RPM_PER_V
#define MTR_RPM_PER_V 675	/*!< ]萔 [rpm/V] */
#endif
#ifndef MTR_MAX_mA
#define MTR_MAX_mA 836		/*!< őAd [mA] */
#endif

#ifndef MTR_TORQUE_CONST
#define MTR_TORQUE_CONST 14.1	/*!< gN萔 [mNm/A] */
#endif

/*
  p[^
*/
#ifndef MTR_GAIN_P
#define MTR_GAIN_P 40		// d݂ 1/1024
#endif
#ifndef MTR_GAIN_I
#define MTR_GAIN_I 2		// d݂ 1/1024
#endif

/*!
  \brief [^̌Œ菬_Zpp[^

  oׂ͂ PWM Œ菬_ɂČvZƂɗpp[^B
*/
#ifndef MTR_I_BIT_WIDTH
#define MTR_I_BIT_WIDTH 11	/*!< d̍őlrbgʒu */
#endif
#ifndef I_VALUE_MAX
#define I_VALUE_MAX 850		/*!< I̒l̍ől */
#endif


#include "cpp_extern_macro.h"
BEGIN_C_DECLS;

extern void set_mode(const unsigned char id, const int mode);
extern void set_pwm(const unsigned char id, const int duty);

extern void initMotor(void);
extern void initMotorInfo(const unsigned char id, motorInfo_t *mtr);
extern void setMotorFree(motorInfo_t *mtr);
extern int setMotorRevolution(const int ref_cnt, const int cnt_diff,
			      motorInfo_t *mtr);

END_C_DECLS;
#endif /* !MOTOR_CTRL_H */
