#ifndef RUN_CTRL_CPP_H
#define RUN_CTRL_CPP_H

/*!
  \file
  \brief ➑̂Ɋ֘A鑀
  
  \author Satofumi KAMIMURA

  $Id$
*/

#include "RC_Coordinate.h"
#include <string.h>
#include <stdlib.h>
#include <ctype.h>
#include "dll_macro.h"

#ifndef M_RUN_CTRL_H
using namespace Base;
#endif


/*!
  \brief sVAfoCX̃ftHgݒ
*/
namespace RUN {
  /*!
    \brief ftHgp[^
  */
  enum DEFAULT {
    BAUDRATE = 38400,		/*!< ڑ{[[g */
    STRAIGHT_MM_VEL = 300,	/*!< ix */
    STRAIGHT_MM_ACC = 600,	/*!< ix */
    ROTATE_DIV16_VEL = 0x10000 >> 1, /*!< ]px */
    ROTATE_DIV16_ACC = 0x10000 >> 1, /*!< ]px */
    FOLLOW_RADIUS_MM = 500,	/*!< oHǏ]̋ȗ */
  };
};


/*!
  \brief ➑̃NX

  \todo G[bZ[W̎VvɂBӖs
  \todo {IɁAVXV_Coordinate ̃G[NXpׂ
*/
class DECLSPEC RunCtrl : public RC_Coordinate {
  enum {
    RUN_CTRL_BAURDATE = 38400,
    ERROR_MESSAGE_BUFFER_SIZE = 255,
  };

  void initRunParam(runCtrlParameter_t *runParam);
  long checkVersion(void);

#include "get_keyword.c"
  int searchConfigFile(const char *path);

protected:
  const char *error_message;
  const char *error_device;
  long error_baudrate;
  char error_device_buffer[ERROR_MESSAGE_BUFFER_SIZE];
  char error_message_buffer[ERROR_MESSAGE_BUFFER_SIZE];
  ConnectionDevice *active_con;

  int connectSimulator(void);
    
public:
  /*!
    \addtogroup coordinateCtrl WnR}h
    \{
  */
  RC_Coordinate FS;		/*!< FS Wn */
  RC_Coordinate &GL;		/*!< GL Wn */
  /*! \} */
  

  /*!
    \defgroup system VXeR}h
    \{
  */
  RunCtrl(void);
  ~RunCtrl(void);
  const char *what(void) const throw();
  const char *getError(void) const throw();
  int connect(const char *deviceName, long baudrate = RUN_CTRL_BAURDATE);
  virtual int connect(int argc, char *argv[]);
  int connect(void);
  void disconnect(void);
  bool is_connect(void);
  /*! \} */
  

  /*!
    \defgroup parameterCtrl p[^R}h
    \{
  */
  RunCtrl& setCoordinateCtrlMode(bool effect);
  RunCtrl& setStraightRefVel(int straight_mm_vel);
  RunCtrl& setRotateRefVel(VXV_Direction rotate_div16_vel);
  RunCtrl& setStraightRefAcc(int straight_mm_acc);
  RunCtrl& setRotateRefAcc(VXV_Direction rotate_div16_acc);
  RunCtrl& setCurveRadius(int radius_mm);
  int getCurveRadius(void);
  int getStraightVel(void);
  VXV_Direction getRotateVel(void);
  /*! \} */

  
  /*!
    \defgroup directCmdCtrl ڐR}h
    \{
  */
  RunCtrl& servoCtrl(bool on);
  RunCtrl& setMotorPwm(int id, unsigned char duty);
  RunCtrl& setMotorMode(int id, unsigned char mode);
  RunCtrl& getEncoderVel(int id, int *cnt);
  RunCtrl& setWheelVel(int id, int mm_vel);
  /* \} */
};

#endif /* !RUN_CTRL_CPP_H */
