#ifndef COORDINATE_CTRL_C_H
#define COORDINATE_CTRL_C_H

/*!
  \file
  \brief WnR}h
  
  \author Satofumi KAMIMURA
  
  $Id$
*/

enum {
  CRD_EFFECT_OFF = 0,
  CRD_EFFECT_ON = 1,
};


/*!
  \brief Wn
*/
enum {
  GL = 0,
  FS = 1,
};


/*!
  \brief Wn̏
 */
typedef struct {
  int parent_id;		/*!< eWnID */
  int x;			/*!< Xl[mm] */
  int y;			/*!< Yl[mm] */
  int div16;			/*!< px[div16] */
} offsetInfo_t;


#include "dll_macro.h"
#include "cpp_extern_macro.h"
BEGIN_C_DECLS;			/*!< \brief C++p̃}N */

extern void _initCoordinateCtrl(offsetInfo_t *crdInfo, int num);
extern DECLSPEC int RCCALL getBodyPos(int crd_id, int *x, int *y, int *div16);
extern DECLSPEC int RCCALL createCoordinate(void);
extern DECLSPEC int RCCALL deleteCoordinate(int crd_id);
extern DECLSPEC int RCCALL getParentId(int crd_id);
extern DECLSPEC int RCCALL getCoordinateOffset(int *offset_x, int *offset_y,
					       int *offset_div16,
					       int base_id, int target_id,
					       int x, int y, int div16);
extern int updateParentOffset(int dest_id, int x, int y, int div16);
extern DECLSPEC int RCCALL setCoordinateParent(int dest_id,
					       int parent_id,
					       int x, int y, int div16);
extern DECLSPEC int RCCALL setCoordinateBody(int dest_id,
					     int x, int y, int div16);
extern DECLSPEC int RCCALL adjustBodyPos(int x, int y, int div16);

END_C_DECLS;			/*!< \brief C++p̃}N */
#endif /* !COORDINATE_CTRL_C_H */
