#ifndef VXV_COORDINATE_H
#define VXV_COORDINATE_H

/*!
  \file
  \brief Wñ{bgɂẴC^[tF[X
  
  \author Satofumi KAMIMURA

  $Id$

  \todo Uŝ
  \todo FS ɑ΂Wn̒t֎~邩
*/

#include "vxvUtils.h"
#include "dll_macro.h"
#include <list>


/*!
  \brief WnNX

  \todo O̎ςȂ̂ǂɂBƂ_
*/
class DECLSPEC VXV_Coordinate {
  friend class RC_Coordinate;

protected:

  /*!
    \brief Wnc[̈Ԑ擪ɂIuWFNgւ̃|C^Ԃ

    \param Ȃ
    \retval NULL
  */
  virtual VXV_Coordinate* getGLObj(void) {
    return NULL;
  }

  /*!
    \brief eWnIuWFNgւ̃|C^Ԃ

    \param Ȃ
    \retval NULL
  */
  virtual VXV_Coordinate* getParentObj(void) {
    return NULL;
  }

  /*!
    \brief qWnւ̃|C^i[XgReiւ̃|C^Ԃ

    \param Ȃ
    \retval NULL
  */
  virtual std::list<RC_Coordinate*>* getChildrenObj(void) {
    return NULL;
  }
  
  
public:
  virtual ~VXV_Coordinate(void) {}


  /*!
    \defgroup coordinateCtrl WnR}h
    \{
  */

  /*!
    \brief 莩Ȉʒu̎擾
    
    \retval VXV_Position ʒuIuWFNg
  */
  virtual VXV_Position getPosition(void) = 0;

  /*!
    \brief eWnւ̎Q
    
    \retval VXV_Coordinate& eWnւ̎Q
  */
  virtual VXV_Coordinate& getParent(void) = 0;
  
  /*!
    \brief w肵ʒuƐeWnƂ̑ΈʒuԂ

    \param x [i] XWl
    \param y [i] YWl
    \param t [i] px
    \retval eWnƂ̃ItZbgʒu
  */
  virtual VXV_Position getParentOffset(int x, int y,
				       const VXV_Direction& t) = 0;

  /*!
    \overload

    \param position [i] ʒu
  */
  virtual VXV_Position getParentOffset(const VXV_Position& position) = 0;
  
  /*!
    \brief w肵WnƎWnƂ̑ΈʒuԂ

    \param x [i] XWl
    \param y [i] YWl
    \param t [i] px
    \param base [i] Wn
    \retval eWnƂ̃ItZbgʒu
  */
  virtual VXV_Position getCoordinateOffset(int x, int y,
					   const VXV_Direction& t,
					   const VXV_Coordinate& base) = 0;

  /*!
    \overload

    \param position [i] ʒu
    \param base [i] Wn
  */
  virtual VXV_Position getCoordinateOffset(const VXV_Position& position,
					   const VXV_Coordinate& base) = 0;

  /*!
    \brief WnIuWFNg̕
    
    \retval WnIuWFNg
  */
  virtual VXV_Coordinate& clone() = 0;
  
  /*!
    \brief VKWn̍쐬
    
    ԂWnIuWFNǵAĂяoIuWFNg̎qWnƂȂ

    \param x [i] XWl
    \param y [i] YWl
    \param t [i] px
    \retval WnIuWFNg
    
    \attention FS eɐݒ肷WńAFS ʉ߂ GL ɒt
  */
  virtual VXV_Coordinate& createCoordinate(int x, int y,
					   const VXV_Direction& t) = 0;

  /*!
    \overload

    \param position [i] ʒu
  */
  virtual VXV_Coordinate& createCoordinate(const VXV_Position& position) = 0;

  /*!
    \overload
  */
  virtual VXV_Coordinate& createCoordinate(void) = 0;

  
  /*!
    \brief Wn̒ւ
    
    wWn̎wʒuɁAWn𒣂t
    
    \param base [i] eƂȂWn
    \param x [i] X Wl
    \param y [i] Y Wl
    \param t [i] px
    \retval *this
  */
  virtual VXV_Coordinate& setCoordinate(VXV_Coordinate& base, int x, int y,
					const VXV_Direction& t) = 0;

  /*!
    \overload

    \param base [i/o] Wn
    \param offset [i] Έʒu
  */
  virtual VXV_Coordinate& setCoordinate(VXV_Coordinate& base,
					const VXV_Position& offset) = 0;

  /*!
    \brief eWnƂ̑ΈʒuXV
    
    \param base [i] Wn
    \param x [i] X Wl
    \param y [i] Y Wl
    \param t [i] px
    \retval *this
  */
  virtual VXV_Coordinate& updateParentOffset(const VXV_Coordinate& base,
					     int x, int y,
					     const VXV_Direction& t) = 0;
  
  /*!
    \overload

    \param offset [i] Έʒu
  */
  virtual VXV_Coordinate& updateParentOffset(const VXV_Position& offset) = 0;

  /*!
    \overload

    \param x [i] X Wl
    \param y [i] Y Wl
    \param t [i] px
  */
  virtual VXV_Coordinate& updateParentOffset(int x, int y,
					     const VXV_Direction& t) = 0;

  /*!
    \overload

    \param base [i] Wn
  */
  virtual VXV_Coordinate& updateParentOffset(const VXV_Coordinate& base) = 0;

  /*!
    \overload

    \param base [i] Wn
    \param offset [i] Έʒu
  */
  virtual VXV_Coordinate& updateParentOffset(const VXV_Coordinate& base,
					     const VXV_Position& offset) = 0;
  
  /*!
    \brief ➑̈ʒuWnɐݒ肷
    
    \param x [i] X Wl
    \param y [i] Y Wl
    \param t [i] px
    \retval *this
  */
  virtual VXV_Coordinate& updateRobotPosition(int x, int y,
					      const VXV_Direction& t) = 0;

  /*!
    \overload

    \param position [i] ʒu
  */
  virtual VXV_Coordinate& updateRobotPosition(const VXV_Position& position) = 0;
  /* \} */
  
  
  /*!
    \defgroup judgementCtrl R}h
    \{
  */

  /*!
    \brief w_➑̈ʒuƂ̋Ԃ
    
    \param x [i] X Wl
    \param y [i] Y Wl
    \retval w_➑̈ʒuƂ̋ [mm]
  */
  virtual int getLengthToBody(int x, int y) = 0;

  /*!
    \brief w蒼➑̈ʒuƂ̋Ԃ
    
    \param x [i] X Wl
    \param y [i] Y Wl
    \param t [i] px
    \retval w蒼➑̈ʒuƂ̋ [mm]
  */
  virtual int getLengthToLine(int x, int y, const VXV_Direction& t) = 0;

  /*!
    \overload
    
    \param position [i] ʒu
  */
  virtual int getLengthToLine(const VXV_Position& position) = 0;
  
  /*!
    \brief wpx➑̌Ƃ̑ΊpxԂ
    
    \param t [i] px
    \retval wpx➑̌Ƃ̑Ίpx
  */
  virtual VXV_Direction getAngleToDirection(const VXV_Direction& t) = 0;

  /*!
    \brief wix➑̂̕ix̍Ԃ
    
    \param ref_vel [i] wix [mm/sec]
    \retval wix➑̂̕ix̍ [mm/sec]
  */
  virtual int getStraightVelDiff(int ref_vel) = 0;

  /*!
    \brief w]x➑̂̉]x̍Ԃ
    
    \param ref_vel [i] w]px [div16/sec]
    \retval w]x➑̂̉]x̍ [div16/sec]
  */
  virtual VXV_Direction getRotateVelDiff(const VXV_Direction& ref_vel) = 0;


  /*!
    \brief iA]̐䂪艻Ă邩Ԃ
    
    \retval iA]̐䂪艻Ă邩
  */
  virtual bool isStable(void) = 0;
  /* \} */
  

  /*!
    \defgroup moveCtrl ړR}h
    \{
  */

  /*!
    \brief Ǐ]
    
    \param x [i] X Wl
    \param y [i] Y Wl
    \param t [i] px
  */
  virtual void followLine(int x, int y, const VXV_Direction& t) = 0;

  /*!
    \overload

    \param position [i] ʒu
  */
  virtual void followLine(const VXV_Position& position) = 0;

  /*!
    \brief ~ʒǏ]
    
    radius > 0 ̂ƂvAradius < 0 ̂Ƃvɉ~ʒǏ]
    
    \param x [i] X Wl
    \param y [i] Y Wl
    \param radius [i] Ǐ]~ʂ̔a [mm]
  */
  virtual void followCircle(int x, int y, int radius) = 0;

  /*!
    \overload
    
    \param position [i] ʒu
    \param radius [i] Ǐ]~ʂ̔a [mm]
  */
  virtual void followCircle(const VXV_Position& position, int radius) = 0;


  /*!
    \brief ړ_w̉~ʒǏ]
    
    wړ_ɐڂ~ʂɒǏ]Bradius > 0 ̂ƂvAradius < 0 ̂Ƃvɉ~ʒǏ]
    
    \param x [i] X Wl
    \param y [i] Y Wl
    \param t [i] px
    \param radius [i] Ǐ]~ʂ̔a
*/
  virtual void followCircleOnTangent(int x, int y,
				     const VXV_Direction& t,
				     int radius) = 0;

  /*!
    \overload
    
    \param position [i] ʒu
    \param radius [i] Ǐ]~ʂ̔a
  */
  virtual void followCircleOnTangent(const VXV_Position& position,
				     int radius) = 0;

  /*!
    \brief w蒼ɂĒ~
    
    \param x [i] X Wl
    \param y [i] Y Wl
    \param t [i] px
  */
  virtual void stopToLine(int x, int y, const VXV_Direction& t) = 0;
  
  /*!
    \overload
    
    \param position [i] ʒu
  */
  virtual void stopToLine(const VXV_Position& position) = 0;

  /*!
    \brief wpx܂œ]
    
    \param t [i] px
  */
  virtual void turnToAngle(const VXV_Direction& t) = 0;

  /*!
    \brief wpx]
    
    \param t [i] px
  */
  virtual void rotateAngle(const VXV_Direction& t) = 0;


  /*!
    \brief w]pxɂĉ]
    
    \param v [i] px [px/sec]
  */
  virtual void spin(const VXV_Direction& v) = 0;

  /*!
    \brief ~
  */
  virtual void stop(void) = 0;

  /*!
    \brief ŌɔsړR}hĔs
  */
  virtual void lastMoveCommand(void) = 0;
  /* \} */
};

#endif /* !VXV_COORDINATE_H */
