#ifndef RC_COORDINATE_H
#define RC_COORDINATE_H

/*!
  \file
  \brief WnɊ֘A鑀
  
  \author Satofumi KAMIMURA

  $Id$

  \todo Uŝ
  \todo FS ɑ΂Wn̒t֎~邩
*/

#include "VXV_Coordinate.h"
#include "vxvUtils.h"
#include "connectionDevice.h"
#include "nodeAccess.h"
#include "structTables.h"
#include <exception>
#include <list>
#include <stdio.h>
#include "dll_macro.h"


/*!
  \brief s̗ONX
*/
#ifndef _MBCS
class DECLSPEC RunCtrlError
#else
class DECLSPEC RunCtrlError : public std::exception 
#endif
{
public:
  virtual ~RunCtrlError(void) {}

  /*!
    \brief O̕Ԃ
  */
  virtual const char* what(void) const throw() {
    return "RunCtrl exception";
  }
  
  /*!
    \brief O̕Ԃ
    
    \attention Ȃׂ what() g
  */
  virtual const char* getError(void) const throw() {
    return what();
  }
};


/*!
  \brief Wn̗ONX
*/
class DECLSPEC CoordinateError : public std::exception {
  enum {
    ERROR_MESSAGE_BUFFER_SIZE = 255,
  };
  const char *error_message;
  const char *fail_command;
  char error_message_buffer[ERROR_MESSAGE_BUFFER_SIZE];
public:

  /*!
    \brief O֐ݒ
  */
  CoordinateError(const char *failCommand) {
    sprintf(error_message_buffer, "Coordinate exception: %s", failCommand);
  }

  /*!
    \brief O̕Ԃ
  */
  virtual const char* what(void) const throw() {
    return error_message_buffer;
  }
  
  /*!
    \brief O̕Ԃ

    \attention Ȃׂ what() g
  */
  virtual const char* getError(void) const throw() {
    return what();
  }
};


/*!
  \brief ʐM̗ONX
*/
class DECLSPEC ConnectionError : public std::exception {
  enum {
    ERROR_MESSAGE_BUFFER_SIZE = 255,
  };
  const char *error_message;
  const char *fail_command;
  char error_message_buffer[ERROR_MESSAGE_BUFFER_SIZE];
public:

  /*!
    \brief O֐ݒ
  */
  ConnectionError(const char *failCommand) {
    sprintf(error_message_buffer, "Connection exception: %s", failCommand);
  }

  /*!
    \brief O֐Aݒ
  */
  ConnectionError(const char *failCommand, int arg1) {
    sprintf(error_message_buffer, "Connection exception: %s, %d",
	    failCommand, arg1);
  }

  /*!
    \brief O֐Aݒ
  */
  ConnectionError(const char *failCommand, int arg1, int arg2, int arg3) {
    sprintf(error_message_buffer, "Connection exception: %s, %d, %d, %d",
	    failCommand, arg1, arg2, arg3);
  }
  
  /*!
    \brief O̕Ԃ
  */
  virtual const char* what(void) const throw() {
    return error_message_buffer;
  }

  /*!
    \brief O̕Ԃ

    \attention Ȃׂ what() g
  */
  virtual const char* getError(void) const throw() {
    return what();
  }
};


/*!
  \brief WnNX

  \todo O̎ςȂ̂ǂɂBƂ_
*/
class DECLSPEC RC_Coordinate : public VXV_Coordinate {
  friend class RunCtrl;
  
  enum { SEND_COMMAND_SIZE = 256 };
  
  enum CoordinateAttribute {
    RC_GL,
    RC_FS,
    RC_LC,
  };

  typedef struct {
    int straight_ref_vel;
    int straight_ref_acc;
    int rotate_ref_vel;
    int rotate_ref_acc;
    int follow_r;
  } runCtrlParameter_t;

#include "commandCtrl.h"
  
  // WñItZbg
  VXV_Position crd_offset;
  CoordinateAttribute crd_attribute;
  
  // eAqA̍WnIuWFNgւ̎Q
  VXV_Coordinate *crd_gl;
  VXV_Coordinate *crd_parent;
  std::list<RC_Coordinate*> crd_children;

protected:
  // ʐM|C^Ŏ
  ConnectionDevice **con;

  RC_Coordinate(void);

private:
  runCtrl_t *run;
  nodeInfo_t *node;
  long *unique_id;
  runCtrlParameter_t *runParam;

  // ړR}hĔsp
  int send_command_size;
  unsigned char send_command[SEND_COMMAND_SIZE];
  VXV_Position cmdPos;
  bool *crdEffectMode;
  
  VXV_Position getGLCoordinateOffset(int x, int y, const VXV_Direction& t);

  VXV_Coordinate* getGLObj(void);
  VXV_Coordinate* getParentObj(void);
  std::list<RC_Coordinate*>* getChildrenObj(void);
  
public:
  ~RC_Coordinate(void);
  RC_Coordinate(const RC_Coordinate& rhs);
  RC_Coordinate& operator=(const RC_Coordinate& rhs);


  // coordinateCtrl WnR}h
  VXV_Position getPosition(void);
  VXV_Coordinate& getParent(void);
  
  VXV_Position getParentOffset(const VXV_Position& position);
  VXV_Position getParentOffset(int x, int y, const VXV_Direction& t);
  VXV_Position getCoordinateOffset(const VXV_Position& position,
				   const VXV_Coordinate& base);
  VXV_Position getCoordinateOffset(int x, int y, const VXV_Direction& t,
				   const VXV_Coordinate& base);

  VXV_Coordinate& clone();

  VXV_Coordinate& createCoordinate(void);
  VXV_Coordinate& createCoordinate(const VXV_Position& position);
  VXV_Coordinate& createCoordinate(int x, int y, const VXV_Direction& t);

  VXV_Coordinate& setCoordinate(VXV_Coordinate& base,
				const VXV_Position& offset);
  VXV_Coordinate& setCoordinate(VXV_Coordinate& base,
				int x, int y, const VXV_Direction& t);

  VXV_Coordinate& updateParentOffset(const VXV_Position& offset);
  VXV_Coordinate& updateParentOffset(int x, int y, const VXV_Direction& t);
  VXV_Coordinate& updateParentOffset(const VXV_Coordinate& base);
  VXV_Coordinate& updateParentOffset(const VXV_Coordinate& base,
				     int x, int y, const VXV_Direction& t);
  VXV_Coordinate& updateParentOffset(const VXV_Coordinate& base,
				     const VXV_Position& offset);

  VXV_Coordinate& updateRobotPosition(int x, int y, const VXV_Direction& t);
  VXV_Coordinate& updateRobotPosition(const VXV_Position& position);

  
  // judgementCtrl
  int getLengthToBody(int x, int y);
  int getLengthToLine(int x, int y, const VXV_Direction& t);
  int getLengthToLine(const VXV_Position& position);
  VXV_Direction getAngleToDirection(const VXV_Direction& t);
  int getStraightVelDiff(int ref_vel);
  VXV_Direction getRotateVelDiff(const VXV_Direction& ref_vel);
  bool isStable(void);
  

  // moveCtrl
  void followLine(const VXV_Position& position);
  void followLine(int x, int y, const VXV_Direction& t);
  void followCircle(const VXV_Position& position, int radius);
  void followCircle(int x, int y, int radius);
  void followCircleOnTangent(const VXV_Position& position, int radius);
  void followCircleOnTangent(int x, int y, const VXV_Direction& t,
			     int radius);
  void stopToLine(const VXV_Position& position);
  void stopToLine(int x, int y, const VXV_Direction& t);
  void turnToAngle(const VXV_Direction& t);
  void rotateAngle(const VXV_Direction& t);
  void spin(const VXV_Direction& v);
  void stop(void);
  void lastMoveCommand(void);
};

#endif /* !RC_COORDINATE_H */
