/*
  p[^
  Satofumi KAMIMURA
  $Id$
*/

#include "runCtrl.h"


/*!
  \brief Wn̑삪soHɉeyڂݒ

  \param effect [i] e^邩
  \retval *this
*/
RunCtrl& RunCtrl::setCoordinateCtrlMode(bool effect) {
  
  *crdEffectMode = effect;
  
  return *this;
}


/*!
  \brief W̕ixݒ

  \param straight_mm_vel [i] Wix [mm/sec]
  \retval *this
*/
RunCtrl& RunCtrl::setStraightRefVel(int straight_mm_vel) {
  runParam->straight_ref_vel = straight_mm_vel;
  if (sendStraightRef(straight_mm_vel, runParam->straight_ref_acc) < 0) {
    throw ConnectionError("setStraightRefVel", straight_mm_vel);
  }
  return *this;  
}


/*!
  \brief W̕ixݒ

  \param rotate_div16_vel [i] Wix [div16/sec]
  \retval *this
*/
RunCtrl& RunCtrl::setRotateRefVel(VXV_Direction rotate_div16_vel) {
  runParam->rotate_ref_vel = rotate_div16_vel.div16;
  if (sendRotateRef(rotate_div16_vel.div16, runParam->rotate_ref_acc) < 0) {
    throw ConnectionError("setRotateRefVel", rotate_div16_vel.deg());
  }
  return *this;  
}


/*!
  \brief W̕ixݒ

  \param straight_mm_acc [i] Wix [mm/sec^2]
  \retval *this
*/
RunCtrl& RunCtrl::setStraightRefAcc(int straight_mm_acc) {
  runParam->straight_ref_acc = straight_mm_acc;
  if (sendStraightRef(runParam->straight_ref_vel, straight_mm_acc) < 0) {
    throw ConnectionError("setStraightRefAcc", straight_mm_acc);
  }
  return *this;
}


/*!
  \brief W̉]pxݒ
  
  \param rotate_div16_acc [i] Wix [div16/sec^2]
  \retval *this
*/
RunCtrl& RunCtrl::setRotateRefAcc(VXV_Direction rotate_div16_acc) {
  runParam->rotate_ref_acc = rotate_div16_acc.div16;
  if (sendRotateRef(runParam->rotate_ref_vel, rotate_div16_acc.div16) < 0) {
    throw ConnectionError("setRotateRefAcc", rotate_div16_acc.deg());
  }
  return *this;
}


/*!
  \brief Ǐ]̋ȗݒ

  \param radius_mm [i] oHǏ]̋ȗ [mm]
  \retval *this
*/
RunCtrl& RunCtrl::setCurveRadius(int radius_mm) {
  runParam->follow_r = radius_mm;
  if (sendCurveRadius(radius_mm) < 0) {
    throw ConnectionError("setCurveRadius", radius_mm);
  }
  return *this;
}


/*!
  \brief Ǐ]̋ȗ擾

  \param Ȃ
  \retval ȗ̒l [mm]
*/
int RunCtrl::getCurveRadius(void) {
  return runParam->follow_r;
}


/*!
  \brief ➑̂̕ix擾

  \retval ➑̂̕ix [mm/sec]
*/
int RunCtrl::getStraightVel(void) {
  int straight_vel;
  
  if (recvStraightVel(&straight_vel)) {
    throw ConnectionError("getStraightVel");
  }
  
  return straight_vel;
}


/*!
  \brief ➑̂̉]px擾
  
  \retval ➑̂̉]x [div16/sec]
*/
VXV_Direction RunCtrl::getRotateVel(void) {
  int rotate_vel;
  if (recvRotateVel(&rotate_vel)) {
    throw ConnectionError("getRotateVel");
  }
  VXV_Direction direction;
  direction.div16 = rotate_vel;

  return direction;
}
