/*
  TCP/IP 
  Satofumi KAMIMURA
  $Id$
*/

#include "tcpip_device.h"
#include "ringBuffer.h"
#ifdef HAVE_LIBSDL_NET
#include <SDL_net.h>
#endif

enum {
  FALSE = 0, TRUE = 1,
  RING_SIZE_SHIFT = 10,
};


#ifdef HAVE_LIBSDL_NET
static int Is_disconnected = FALSE;
static TCPsocket Tcp_socket = NULL;
static SDLNet_SocketSet Socket_set = NULL;
static ringBuffer_t Ring;
static unsigned char Buffer[1 << RING_SIZE_SHIFT];
static int Is_initialized = FALSE;
#endif


#ifdef HAVE_LIBSDL_NET
static void initialize(void) {
  Socket_set = SDLNet_AllocSocketSet(1);
  initRingBuffer(&Ring, Buffer, RING_SIZE_SHIFT);
}
#endif


int tcpip_open(const unsigned char *host, unsigned short port) {
#ifdef HAVE_LIBSDL_NET
  IPaddress ip;
  SDLNet_ResolveHost(&ip, host, port);

  if (Is_initialized == FALSE) {
    Is_initialized = TRUE;
    initialize();
  }

  Tcp_socket = SDLNet_TCP_Open(&ip);
  if (!Tcp_socket) {
    tcpip_close();
    return -1;
  }
  SDLNet_TCP_AddSocket(Socket_set, Tcp_socket);
  return 0;
#else
  return -1;
#endif
}


void tcpip_close(void) {
#ifdef HAVE_LIBSDL_NET
  Is_disconnected = TRUE;
  if (Tcp_socket) {
    SDLNet_TCP_DelSocket(Socket_set, Tcp_socket);
    SDLNet_TCP_Close(Tcp_socket);
    Tcp_socket = NULL;
  }
#endif
}


int tcpip_is_connect(void) {
#ifdef HAVE_LIBSDL_NET
  return ((Tcp_socket != NULL) && !Is_disconnected) ? TRUE : FALSE;
#else
  return FALSE;
#endif
}


#ifdef HAVE_LIBSDL_NET
static void check(int timeout) {
  if ((getRingFillSize(&Ring) > 0) ||
      (SDLNet_CheckSockets(Socket_set, timeout) <= 0)) {
    return;
  }
  if (tcpip_is_connect() && SDLNet_SocketReady(Tcp_socket)) {
    int maxlen = getRingFreeSize(&Ring);
    unsigned char buffer[BUFSIZ];
    int n;
    maxlen = (maxlen > BUFSIZ) ? BUFSIZ : maxlen;
    n = SDLNet_TCP_Recv(Tcp_socket, buffer, maxlen);
    if (n <= 0) {
      Is_disconnected = TRUE;
      return;
    }
    putRingBufferStr(&Ring, buffer, n);
  }
}
#endif


int tcpip_recv(unsigned char *data, int size, int timeout) {
#ifdef HAVE_LIBSDL_NET
  int len;
  check(timeout);
  if (!tcpip_is_connect()) {
    return -1;
  }

  len = (getRingFillSize(&Ring) > size) ? size : getRingFillSize(&Ring);
  if (len == 0) {
    return 0;
  }
  getRingBufferStr(&Ring, data, len);
  
  return len;
#else
  return -1;
#endif
}


int tcpip_send(const unsigned char *data, int length) {
#ifdef HAVE_LIBSDL_NET
  check(0);
  if (!tcpip_is_connect()) {
    return -1;
  }
  
  return SDLNet_TCP_Send(Tcp_socket, (void *)data, length);
#else
  return -1;
#endif
}
