/*
  p[^
  Satofumi KAMIMURA
  $Id$
*/

#include "parameter_ctrl.h"
#include "commandCtrl.h"


static runCtrlParameter_t *RunParam = NULL;


/*!
  \brief p[^̏

  \param runParam [o] \

  \attention [UĂԕKv͂Ȃ
*/
void _initRunParam(runCtrlParameter_t *runParam) {
  RunParam = runParam;
  RunParam->straight_ref_vel = STRAIGHT_MM_VEL;
  RunParam->straight_ref_acc = STRAIGHT_MM_ACC;
  RunParam->rotate_ref_vel = ROTATE_DIV16_VEL;
  RunParam->rotate_ref_acc = ROTATE_DIV16_ACC;
  RunParam->follow_r = FOLLOW_RADIUS_MM;
}


/*!
  \brief ڕWixݒ

  \param mm_vel [i] ڕWix [mm/sec]
  \retval 0 I
  \retval ߂l < 0 G[
*/
DECLSPEC int RCCALL setStraightVel(int mm_vel) {
  RunParam->straight_ref_vel = mm_vel;
  if (sendStraightRef(mm_vel, RunParam->straight_ref_acc) < 0) {
    return -1;
  }
  return 0;
}


/*!
  \brief ixݒ

  \param mm_acc [i] x {mm/sec^2]
  \retval 0 I
  \retval ߂l < 0 G[
*/
DECLSPEC int RCCALL setStraightAcc(int mm_acc) {
  RunParam->straight_ref_acc = mm_acc;
  if (sendStraightRef(RunParam->straight_ref_vel, mm_acc) < 0) {
    return -1;
  }
  return 0;
}


/*!
  \brief ڕW]xݒ

  \param div16_vel [i] ڕWpx [div16/sec]
  \retval 0 I
  \retval ߂l < 0 G[
*/
DECLSPEC int RCCALL setRotateVel(int div16_vel) {
  RunParam->rotate_ref_vel = div16_vel;
  if (sendRotateRef(div16_vel, RunParam->rotate_ref_acc) < 0) {
    return -1;
  }
  return 0;
}


/*!
  \brief ]xݒ

  \param div16_acc [i] ]x {div16/sec^2]
  \retval 0 I
  \retval ߂l < 0 G[
*/
DECLSPEC int RCCALL setRotateAcc(int div16_acc) {
  RunParam->rotate_ref_acc = div16_acc;
  if (sendRotateRef(RunParam->rotate_ref_vel, div16_acc) < 0) {
    return -1;
  }
  return 0;
}


/*!
  \brief oHǏ]ɑQߎۂ̋ȗw

  \param radius_mm [i] a [mm]
  \retval 0 I
  \retval ߂l < 0 G[
*/
DECLSPEC int RCCALL setCurveRadius(int radius_mm) {
  RunParam->follow_r = radius_mm;
  if (sendCurveRadius(radius_mm) < 0) {
    return -1;
  }
  return 0;
}


/*!
  \brief ix擾

  \param *mm_vel [o] ix [mm/sec]
  \retval 0 I
  \retval ߂l < 0 G[
*/
DECLSPEC int RCCALL getStraightVel(int *mm_vel) {
  return recvStraightVel(mm_vel);
}


/*!
  \brief ix擾

  \param *div16_vel [o] ]x [div16/sec]
  \retval 0 I
  \retval ߂l < 0 G[
*/
DECLSPEC int RCCALL getRotateVel(int *div16_vel) {
  return recvRotateVel(div16_vel);
}


/*!
  \brief Ԃ肵Ă邩

  \retval 0 
  \retval -1 s
*/
DECLSPEC int RCCALL is_stable(void) {
  int isStable;
  int ret_value = recvStableValue(&isStable);
  if (ret_value < 0) {
    return ret_value;
  }
  return isStable;
}
