/*
  pPbg̃zXg
  Satofumi KAMIMURA
  $Id$
*/

#include "packetHandleHost.h"
#include "nodeAccess.h"
#ifndef __cplusplus
#include "connect_device.h"
#endif

#ifdef __cplusplus
#define CON_RECV(X, Y, Z) con->recv(X, Y, Z)
#define CON_SEND(X, Y) con->send(X, Y)
#else
#define CON_RECV(X, Y, Z) device_recv(X, Y, Z)
#define CON_SEND(X, Y) device_send(X, Y)
#endif


enum {
  SEND_PACKET_SIZE = 512,
  TIMEOUT_SHIFT = 4,
};


#ifdef __cplusplus
int waitPacketResponse(ConnectionDevice *con, runCtrl_t *run,
		       unsigned char *send_packet, int send_size,
		       long send_unique_id) {
#else
  int waitPacketResponse(unsigned char dummy, runCtrl_t *run,
			 unsigned char *send_packet, int send_size,
			 long send_unique_id) {
#endif
    enum { NO_RETRY, SEND_RETRY };
    unsigned char recv_buffer[SEND_PACKET_SIZE];
    int last = 0;
    int first = 0;
    int retry_times = 0;
    int ret_value = -1;
    int packet_length;
    long recv_unique_id;
    int left_length;
    char type;
    int send_retry_mode = SEND_RETRY;

#ifdef __cplusplus
    if (!con) {
      return -2;
    }
#else
    if (!device_is_connect()) {
      return -2;
    }
#endif
    do {
      if (send_retry_mode != NO_RETRY) {
	CON_SEND(send_packet, send_size);
      }
      send_retry_mode = SEND_RETRY;
      last += CON_RECV(&recv_buffer[last],
		       NODE_ACCESS_REPLY_PACKET_SIZE,
		       send_size << TIMEOUT_SHIFT);
      if (last < NODE_ACCESS_REPLY_PACKET_SIZE) {
	// Mf[^wb_ɖȂꍇ
	ret_value = -2;
	continue;
      }
      // wb_̃`FbNTmF
      while ((last > NODE_ACCESS_REPLY_PACKET_SIZE) &&
	     (checkHeaderFormat(&recv_buffer[first]) < 0)) {
	++first;
      }
    
      // wb_ApPbg擾
      recv_unique_id = getPacketUniqueId(&recv_buffer[first]);
      if (recv_unique_id != send_unique_id) {
	ret_value = -3;
	first = last;
	--retry_times;
	send_retry_mode = NO_RETRY;
	continue;
      }
    
      packet_length = getPacketLength(&recv_buffer[first]);
      left_length = packet_length - (last - first);
    
      // pPbĝ҂
      last += CON_RECV(&recv_buffer[last], left_length,
		       left_length << TIMEOUT_SHIFT);
    
      // pPbg͂Ȃ΁ApPbgđĉ҂
      if ((last - first) < packet_length) {
	ret_value = -4;
	continue;
      }
      // pPbg̃`FbNTɃG[ĂAđĉ҂
      if (checkPacketFormat(&recv_buffer[first], packet_length) < 0) {
	ret_value = -5;
	continue;
      }
    
      // wb_ApPbg̃^Cv擾
      type = getPacketType(&recv_buffer[first]);
      switch (type) {

	// ݉ւ̏
      case PACKET_WRITE_RESPONSE:
	ret_value = retry_times;
	break;

	// ǂݏoւ̏
      case PACKET_READ_RESPONSE:
	writeFromPacketData(&recv_buffer[first], (unsigned char *)run);
	ret_value = retry_times;
	break;
      }
    
      break;
    } while (++retry_times <= NODE_ACCESS_RETRY_TIMES);

    return ret_value;
  }
