#ifndef COMMAND_CTRL_H
#define COMMAND_CTRL_H

/*
  R}h(RC_Coordinatep)
  Satofumi KAMIMURA
  $Id$
*/

#ifndef __cplusplus
#include "nodeAccess.h"
#include "parameter_ctrl.h"
#include "structTables.h"

#define bool int


extern void _initCommandCtrl(runCtrl_t *Run, nodeInfo_t *Node,
			     runCtrlParameter_t *RunParam,
			     int *Unique_id);
#endif
int recvVersion(long *version);
int recvGetPosition(int *x, int *y, long *div16);
int recvStraightVel(int *straight_vel);
int recvRotateVel(int *straight_vel);
int recvStableValue(int *isStable);

int sendPositionInit(void);
int sendServoCtrl(bool on);
int sendFollowLine(int x, int y, int div16,
		   unsigned char *send_packet, int *send_packet_size);
int sendFollowCircle(int x, int y, int radius,
		     unsigned char *send_packet, int *send_packet_size);
int sendStopToLine(int x, int y, int div16,
		   unsigned char *send_packet, int *send_packet_size);
int sendStop(unsigned char *send_packet, int *send_packet_size);
int sendRotateAngle(int rotate_div16,
		    unsigned char *send_packet, int *send_packet_size);
int sendTurnToAngle(int rotate_div16,
		    unsigned char *send_packet, int *send_packet_size);
int sendSpin(int rotate_div16,
	     unsigned char *send_packet, int *send_packet_size);
int sendLastMoveCommand(int last_command_unique_id,
			unsigned char *send_packet, int send_packet_size);
int sendChangeCoordinateOffset(int x, int y, int div16);
int sendStraightRef(int straight_mm_vel, int straight_acc);
int sendRotateRef(int rotate_div16_vel, int rotate_acc);
int sendCurveRadius(int radius_mm);
int sendGLOffset(int x, int y, long div16);
int recvGLOffset(int *x, int *y, long *div16);

int recvEncoderDiff(int id, int *diff);
int sendMotorMode(int id, unsigned char mode);
int sendMotorDuty(int id, unsigned char duty);
int sendWheelVel(int id, int mm_vel);

#endif /* !COMMAND_CTRL_H */
